/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Returns the sum of all array elements, or 0 if the array is empty. Ignores null elements.")
@ScalarFunction(value="array_sum")
public final class ArraySumBigIntFunction {
    private ArraySumBigIntFunction() {
    }

    @SqlType(value="bigint")
    public static long arraySumBigInt(@OperatorDependency(operator=OperatorType.ADD, argumentTypes={"bigint", "bigint"}) MethodHandle addFunction, @TypeParameter(value="bigint") Type elementType, @SqlType(value="array(bigint)") Block arrayBlock) {
        int positionCount = arrayBlock.getPositionCount();
        if (positionCount == 0) {
            return 0L;
        }
        long sum = 0L;
        for (int i = 0; i < positionCount; ++i) {
            if (arrayBlock.isNull(i)) continue;
            try {
                sum = addFunction.invoke(sum, arrayBlock.getLong(i));
                continue;
            }
            catch (Throwable throwable) {
                throw Failures.internalError(throwable);
            }
        }
        return sum;
    }
}

