/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;

@ScalarFunction(value="reverse")
@Description(value="Returns an array which has the reversed order of the given array.")
public final class ArrayReverseFunction {
    @TypeParameter(value="E")
    public ArrayReverseFunction(@TypeParameter(value="E") Type elementType) {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block reverse(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (arrayLength < 2) {
            return block;
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, block.getPositionCount());
        for (int i = arrayLength - 1; i >= 0; --i) {
            type.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }
}

