/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.OptimizedTypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

public final class ArrayIntersectFunction {
    private ArrayIntersectFunction() {
    }

    @ScalarFunction(value="array_intersect")
    @Description(value="Intersects elements of the two given arrays")
    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block intersect(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int rightPositionCount;
        if (leftArray.getPositionCount() < rightArray.getPositionCount()) {
            Block tempArray = leftArray;
            leftArray = rightArray;
            rightArray = tempArray;
        }
        if ((rightPositionCount = rightArray.getPositionCount()) == 0) {
            return rightArray;
        }
        OptimizedTypedSet typedSet = new OptimizedTypedSet(type, elementIsDistinctFrom, rightPositionCount);
        typedSet.union(rightArray);
        typedSet.intersect(leftArray);
        return typedSet.getBlock();
    }

    @SqlInvokedScalarFunction(value="array_intersect", deterministic=true, calledOnNullInput=false)
    @Description(value="Intersects elements of all arrays in the given array")
    @TypeParameter(value="T")
    @SqlParameter(name="input", type="array<array<T>>")
    @SqlType(value="array<T>")
    public static String arrayIntersectArray() {
        return "RETURN reduce(input, null, (s, x) -> IF((s IS NULL), x, array_intersect(s, x)), (s) -> s)";
    }
}

