/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.ArrayFindFirstIndexWithOffsetFunction;
import com.facebook.presto.operator.scalar.BlockToBooleanFunction;
import com.facebook.presto.operator.scalar.BooleanToBooleanFunction;
import com.facebook.presto.operator.scalar.DoubleToBooleanFunction;
import com.facebook.presto.operator.scalar.LongToBooleanFunction;
import com.facebook.presto.operator.scalar.SliceToBooleanFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import io.airlift.slice.Slice;

@Description(value="Return the index of the first element which matches the given predicate, null if no match")
@ScalarFunction(value="find_first_index", deterministic=true)
public final class ArrayFindFirstIndexFunction
extends ArrayFindFirstIndexWithOffsetFunction {
    private ArrayFindFirstIndexFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="bigint")
    @SqlNullable
    public static Long findBlock(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BlockToBooleanFunction function) {
        return ArrayFindFirstIndexFunction.findBlockUtil(elementType, arrayBlock, 1L, function);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="bigint")
    @SqlNullable
    public static Long findSlice(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") SliceToBooleanFunction function) {
        return ArrayFindFirstIndexFunction.findSliceUtil(elementType, arrayBlock, 1L, function);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="bigint")
    @SqlNullable
    public static Long findLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        return ArrayFindFirstIndexFunction.findLongUtil(elementType, arrayBlock, 1L, function);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="bigint")
    @SqlNullable
    public static Long findDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        return ArrayFindFirstIndexFunction.findDoubleUtil(elementType, arrayBlock, 1L, function);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="bigint")
    @SqlNullable
    public static Long findBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        return ArrayFindFirstIndexFunction.findBooleanUtil(elementType, arrayBlock, 1L, function);
    }
}

