/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import com.google.common.base.Defaults;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_distinct")
@Description(value="Remove duplicate values from the given array")
public final class ArrayDistinctFunction {
    private ArrayDistinctFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block distinct(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(E)") Block array) {
        BlockBuilder distinctElementBlockBuilder;
        int arrayLength = array.getPositionCount();
        if (arrayLength < 2) {
            return array;
        }
        if (arrayLength == 2) {
            boolean distinct;
            boolean firstValueNull = array.isNull(0);
            Object firstValue = firstValueNull ? Defaults.defaultValue((Class)type.getJavaType()) : TypeUtils.readNativeValue((Type)type, (Block)array, (int)0);
            boolean secondValueNull = array.isNull(1);
            Object secondValue = secondValueNull ? Defaults.defaultValue((Class)type.getJavaType()) : TypeUtils.readNativeValue((Type)type, (Block)array, (int)1);
            try {
                distinct = elementIsDistinctFrom.invoke(firstValue, firstValueNull, secondValue, secondValueNull);
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
            if (distinct) {
                return array;
            }
            return array.getSingleValueBlock(0);
        }
        TypedSet typedSet = new TypedSet(type, elementIsDistinctFrom, array.getPositionCount(), "array_distinct");
        if (array.mayHaveNull()) {
            int position;
            int firstDuplicatePosition;
            for (firstDuplicatePosition = 0; firstDuplicatePosition < arrayLength && typedSet.add(array, firstDuplicatePosition); ++firstDuplicatePosition) {
            }
            if (firstDuplicatePosition == arrayLength) {
                return array;
            }
            distinctElementBlockBuilder = type.createBlockBuilder(null, arrayLength);
            for (position = 0; position < firstDuplicatePosition; ++position) {
                type.appendTo(array, position, distinctElementBlockBuilder);
            }
            while (position < arrayLength) {
                if (typedSet.add(array, position)) {
                    type.appendTo(array, position, distinctElementBlockBuilder);
                }
                ++position;
            }
        } else {
            int position;
            int firstDuplicatePosition;
            for (firstDuplicatePosition = 0; firstDuplicatePosition < arrayLength && typedSet.addNonNull(array, firstDuplicatePosition); ++firstDuplicatePosition) {
            }
            if (firstDuplicatePosition == arrayLength) {
                return array;
            }
            distinctElementBlockBuilder = type.createBlockBuilder(null, arrayLength);
            for (position = 0; position < firstDuplicatePosition; ++position) {
                type.appendTo(array, position, distinctElementBlockBuilder);
            }
            while (position < arrayLength) {
                if (typedSet.addNonNull(array, position)) {
                    type.appendTo(array, position, distinctElementBlockBuilder);
                }
                ++position;
            }
        }
        return distinctElementBlockBuilder.build();
    }

    @SqlType(value="array(bigint)")
    public static Block bigintDistinct(@SqlType(value="array(bigint)") Block array) {
        BlockBuilder distinctElementBlockBuilder;
        int arrayLength = array.getPositionCount();
        if (arrayLength < 2) {
            return array;
        }
        LongOpenHashSet set = new LongOpenHashSet(arrayLength);
        if (array.mayHaveNull()) {
            int position;
            boolean containsNull = false;
            for (position = 0; position < arrayLength; ++position) {
                if (array.isNull(position)) {
                    if (containsNull) break;
                    containsNull = true;
                    continue;
                }
                if (!set.add(BigintType.BIGINT.getLong(array, position))) break;
            }
            if (position == arrayLength) {
                return array;
            }
            distinctElementBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, arrayLength);
            for (int i = 0; i < position; ++i) {
                BigintType.BIGINT.appendTo(array, i, distinctElementBlockBuilder);
            }
            ++position;
            while (position < arrayLength) {
                if (array.isNull(position)) {
                    if (!containsNull) {
                        BigintType.BIGINT.appendTo(array, position, distinctElementBlockBuilder);
                    }
                } else if (set.add(BigintType.BIGINT.getLong(array, position))) {
                    BigintType.BIGINT.appendTo(array, position, distinctElementBlockBuilder);
                }
                ++position;
            }
        } else {
            int position;
            for (position = 0; position < arrayLength && set.add(BigintType.BIGINT.getLong(array, position)); ++position) {
            }
            if (position == arrayLength) {
                return array;
            }
            distinctElementBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, arrayLength);
            for (int i = 0; i < position; ++i) {
                BigintType.BIGINT.appendTo(array, i, distinctElementBlockBuilder);
            }
            ++position;
            while (position < arrayLength) {
                if (set.add(BigintType.BIGINT.getLong(array, position))) {
                    BigintType.BIGINT.appendTo(array, position, distinctElementBlockBuilder);
                }
                ++position;
            }
        }
        return distinctElementBlockBuilder.build();
    }
}

