/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.common.Page;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FinishedOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.PageSourceOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.facebook.presto.operator.index.IndexSplit;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class IndexSourceOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final ConnectorIndex index;
    private final Function<RecordSet, RecordSet> probeKeyNormalizer;
    private Operator source;

    public IndexSourceOperator(OperatorContext operatorContext, PlanNodeId planNodeId, ConnectorIndex index, Function<RecordSet, RecordSet> probeKeyNormalizer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.probeKeyNormalizer = Objects.requireNonNull(probeKeyNormalizer, "probeKeyNormalizer is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(ScheduledSplit scheduledSplit) {
        Split split = Objects.requireNonNull(scheduledSplit, "scheduledSplit is null").getSplit();
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.source == null ? 1 : 0) != 0, (Object)"Index source split already set");
        IndexSplit indexSplit = (IndexSplit)split.getConnectorSplit();
        RecordSet normalizedRecordSet = this.probeKeyNormalizer.apply(indexSplit.getKeyRecordSet());
        ConnectorPageSource result = this.index.lookup(normalizedRecordSet);
        this.source = new PageSourceOperator(result, this.operatorContext);
        Object splitInfo = split.getInfo();
        Map<String, String> infoMap = split.getInfoMap();
        if (infoMap != null && !infoMap.isEmpty()) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(infoMap)));
        } else if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(splitInfo)));
        }
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        if (this.source == null) {
            this.source = new FinishedOperator(this.operatorContext);
        }
    }

    @Override
    public void finish() {
        this.noMoreSplits();
        this.source.finish();
    }

    @Override
    public boolean isFinished() {
        return this.source != null && this.source.isFinished();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        if (this.source == null) {
            return null;
        }
        return this.source.getOutput();
    }

    @Override
    public void close() throws Exception {
        if (this.source != null) {
            this.source.close();
        }
    }

    public static class IndexSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final ConnectorIndex index;
        private final Function<RecordSet, RecordSet> probeKeyNormalizer;
        private boolean closed;

        public IndexSourceOperatorFactory(int operatorId, PlanNodeId sourceId, ConnectorIndex index, Function<RecordSet, RecordSet> probeKeyNormalizer) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.probeKeyNormalizer = Objects.requireNonNull(probeKeyNormalizer, "probeKeyNormalizer is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, IndexSourceOperator.class.getSimpleName());
            return new IndexSourceOperator(operatorContext, this.sourceId, this.index, this.probeKeyNormalizer);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

