/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;

public class NullableBooleanStateSerializer
implements AccumulatorStateSerializer<NullableBooleanState> {
    public Type getSerializedType() {
        return BooleanType.BOOLEAN;
    }

    public void serialize(NullableBooleanState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BooleanType.BOOLEAN.writeBoolean(out, state.getBoolean());
        }
    }

    public void deserialize(Block block, int index, NullableBooleanState state) {
        state.setNull(false);
        state.setBoolean(BooleanType.BOOLEAN.getBoolean(block, index));
    }
}

