/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.theta;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchAggregationState;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchStateFactory;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;

@AggregationFunction(value="sketch_theta", isCalledOnNullInput=true)
@Description(value="calculates a theta sketch of the selected input column")
public class ThetaSketchAggregationFunction {
    public static final String NAME = "sketch_theta";

    private ThetaSketchAggregationFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState ThetaSketchAggregationState state, @SqlType(value="T") @BlockPosition Block block, @BlockIndex int position) {
        if (block.isNull(position)) {
            return;
        }
        Union sketch = state.getSketch();
        state.addMemoryUsage(-ThetaSketchStateFactory.getEstimatedMemoryUsage(sketch));
        if (type.getJavaType().equals(Long.class) || type.getJavaType() == Long.TYPE) {
            sketch.update(type.getLong(block, position));
        } else if (type.getJavaType().equals(Double.class) || type.getJavaType() == Double.TYPE) {
            sketch.update(type.getDouble(block, position));
        } else if (type.getJavaType().equals(String.class) || type.getJavaType().equals(Slice.class)) {
            sketch.update(type.getSlice(block, position).getBytes());
        } else {
            throw new RuntimeException("unsupported sketch column type: " + type + " (java type: " + type.getJavaType() + ")");
        }
        state.addMemoryUsage(ThetaSketchStateFactory.getEstimatedMemoryUsage(sketch));
    }

    @CombineFunction
    public static void merge(@AggregationState ThetaSketchAggregationState state, @AggregationState ThetaSketchAggregationState otherState) {
        Union sketch = state.getSketch();
        state.addMemoryUsage(-ThetaSketchStateFactory.getEstimatedMemoryUsage(sketch));
        sketch.union((Sketch)otherState.getSketch().getResult());
        state.addMemoryUsage(ThetaSketchStateFactory.getEstimatedMemoryUsage(sketch));
    }

    @OutputFunction(value="varbinary")
    public static void output(@AggregationState ThetaSketchAggregationState state, BlockBuilder out) {
        Slice output = Slices.wrappedBuffer((byte[])state.getSketch().getResult().toByteArray());
        VarbinaryType.VARBINARY.writeSlice(out, output);
    }
}

