/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="noisy_approx_set_sfm")
public final class NoisyApproximateSetSfmAggregation {
    private NoisyApproximateSetSfmAggregation() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState SfmSketchState state, @SqlType(value="T") long value, @SqlType(value="double") double epsilon, @SqlType(value="bigint") long numberOfBuckets, @SqlType(value="bigint") long precision) {
        SfmSketchAggregationUtils.addHashToSketch(state, SfmSketchAggregationUtils.hashLong(methodHandle, value), epsilon, numberOfBuckets, precision);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState SfmSketchState state, @SqlType(value="T") double value, @SqlType(value="double") double epsilon, @SqlType(value="bigint") long numberOfBuckets, @SqlType(value="bigint") long precision) {
        SfmSketchAggregationUtils.addHashToSketch(state, SfmSketchAggregationUtils.hashDouble(methodHandle, value), epsilon, numberOfBuckets, precision);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}) MethodHandle methodHandle, @AggregationState SfmSketchState state, @SqlType(value="T") Slice value, @SqlType(value="double") double epsilon, @SqlType(value="bigint") long numberOfBuckets, @SqlType(value="bigint") long precision) {
        SfmSketchAggregationUtils.addHashToSketch(state, SfmSketchAggregationUtils.hashSlice(methodHandle, value), epsilon, numberOfBuckets, precision);
    }

    @CombineFunction
    public static void combineState(@AggregationState SfmSketchState state, @AggregationState SfmSketchState otherState) {
        SfmSketchAggregationUtils.mergeStates(state, otherState);
    }

    @OutputFunction(value="SfmSketch")
    public static void evaluateFinal(@AggregationState SfmSketchState state, BlockBuilder out) {
        SfmSketchAggregationUtils.writeSketch(state, out);
    }
}

