/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramStateStrategyUtils;
import com.facebook.presto.operator.aggregation.fixedhistogram.FixedDoubleHistogram;
import com.google.common.collect.Streams;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Objects;

public class FixedHistogramMleStateStrategy
implements DifferentialEntropyStateStrategy {
    private final FixedDoubleHistogram histogram;

    public FixedHistogramMleStateStrategy(long bucketCount, double min, double max) {
        FixedHistogramStateStrategyUtils.validateParameters(bucketCount, min, max);
        this.histogram = new FixedDoubleHistogram(Math.toIntExact(bucketCount), min, max);
    }

    private FixedHistogramMleStateStrategy(FixedHistogramMleStateStrategy other) {
        this.histogram = other.histogram.clone();
    }

    private FixedHistogramMleStateStrategy(FixedDoubleHistogram histogram) {
        this.histogram = Objects.requireNonNull(histogram, "histogram is null");
    }

    @Override
    public void validateParameters(long bucketCount, double sample, double weight, double min, double max) {
        FixedHistogramStateStrategyUtils.validateParameters(this.histogram.getBucketCount(), this.histogram.getMin(), this.histogram.getMax(), bucketCount, sample, weight, min, max);
    }

    @Override
    public void add(double sample, double weight) {
        this.histogram.add(sample, weight);
    }

    @Override
    public double getTotalPopulationWeight() {
        return Streams.stream(this.histogram.iterator()).mapToDouble(FixedDoubleHistogram.Bucket::getWeight).sum();
    }

    @Override
    public double calculateEntropy() {
        double sum = 0.0;
        for (FixedDoubleHistogram.Bucket bucket : this.histogram) {
            sum += bucket.getWeight();
        }
        if (sum == 0.0) {
            return Double.NaN;
        }
        double rawEntropy = 0.0;
        for (FixedDoubleHistogram.Bucket bucket : this.histogram) {
            rawEntropy -= FixedHistogramStateStrategyUtils.getXLogX(bucket.getWeight() / sum);
        }
        return (rawEntropy + Math.log(this.histogram.getWidth())) / Math.log(2.0);
    }

    @Override
    public long getEstimatedSize() {
        return this.histogram.estimatedInMemorySize();
    }

    @Override
    public int getRequiredBytesForSpecificSerialization() {
        return this.histogram.getRequiredBytesForSerialization();
    }

    @Override
    public void mergeWith(DifferentialEntropyStateStrategy other) {
        this.histogram.mergeWith(((FixedHistogramMleStateStrategy)other).histogram);
    }

    public static FixedHistogramMleStateStrategy deserialize(SliceInput input) {
        FixedDoubleHistogram histogram = FixedDoubleHistogram.deserialize(input);
        return new FixedHistogramMleStateStrategy(histogram);
    }

    @Override
    public void serialize(SliceOutput out) {
        this.histogram.serialize(out);
    }

    @Override
    public DifferentialEntropyStateStrategy clone() {
        return new FixedHistogramMleStateStrategy(this);
    }

    @Override
    public DifferentialEntropyStateStrategy cloneEmpty() {
        return new FixedHistogramMleStateStrategy(this.histogram.getBucketCount(), this.histogram.getMin(), this.histogram.getMax());
    }
}

