/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.MapAggregationFunction;
import com.facebook.presto.operator.aggregation.SetOfValues;
import com.facebook.presto.operator.aggregation.arrayagg.SetAggregationStateSerializer;
import com.facebook.presto.operator.aggregation.state.SetAggregationState;
import com.facebook.presto.operator.aggregation.state.SetAggregationStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class SetUnionFunction
extends SqlAggregationFunction {
    public static final SetUnionFunction SET_UNION = new SetUnionFunction();
    public static final String NAME = "set_union";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(SetUnionFunction.class, "input", Type.class, ArrayType.class, MethodHandle.class, SetAggregationState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(SetUnionFunction.class, "combine", SetAggregationState.class, SetAggregationState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(SetUnionFunction.class, "output", SetAggregationState.class, BlockBuilder.class);

    public SetUnionFunction() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)")));
    }

    public String getDescription() {
        return "Given a column of array type, return an array of all the unique values contained in each of the arrays in the column";
    }

    @Override
    public boolean isCalledOnNullInput() {
        return true;
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type elementType = boundVariables.getTypeVariable("T");
        ArrayType inputType = (ArrayType)functionAndTypeManager.getParameterizedType("array", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
        ArrayType outputType = (ArrayType)functionAndTypeManager.getParameterizedType("array", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
        MethodHandle distinctFromMethodHandle = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.IS_DISTINCT_FROM, TypeSignatureProvider.fromTypes((Type[])new Type[]{elementType, elementType}))).getMethodHandle();
        return SetUnionFunction.generateAggregation(elementType, inputType, outputType, distinctFromMethodHandle);
    }

    private static BuiltInAggregationFunctionImplementation generateAggregation(Type elementType, ArrayType inputType, ArrayType outputType, MethodHandle distinctFromMethodHandle) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MapAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)inputType);
        SetAggregationStateSerializer stateSerializer = new SetAggregationStateSerializer(elementType, distinctFromMethodHandle);
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), SetUnionFunction.createInputParameterMetadata((Type)inputType), INPUT_FUNCTION.bindTo(elementType).bindTo(inputType).bindTo(distinctFromMethodHandle), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(SetAggregationState.class, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)new SetAggregationStateFactory(elementType))), (Type)outputType);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)outputType, true, true, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type valueType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, valueType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type elementType, ArrayType arrayType, MethodHandle elementIsDistinctFrom, SetAggregationState state, Block inputBlock, int position) {
        SetOfValues set = state.get();
        if (set == null) {
            set = new SetOfValues(elementType, elementIsDistinctFrom);
            state.set(set);
        }
        long startSize = set.estimatedInMemorySize();
        Block arrayBlock = arrayType.getObject(inputBlock, position);
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            set.add(arrayBlock, i);
        }
        state.addMemoryUsage(set.estimatedInMemorySize() - startSize);
    }

    public static void combine(SetAggregationState state, SetAggregationState otherState) {
        if (state.get() != null && otherState.get() != null) {
            SetOfValues otherSet = otherState.get();
            Block otherValues = otherSet.getvalues();
            SetOfValues set = state.get();
            long startSize = set.estimatedInMemorySize();
            for (int i = 0; i < otherValues.getPositionCount(); ++i) {
                set.add(otherValues, i);
            }
            state.addMemoryUsage(set.estimatedInMemorySize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    public static void output(SetAggregationState state, BlockBuilder out) {
        SetOfValues set = state.get();
        if (set == null) {
            out.appendNull();
        } else {
            set.serialize(out);
        }
    }
}

