/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.QuantileDigestAggregationFunction;
import com.facebook.presto.operator.aggregation.StatisticalDigest;
import com.facebook.presto.operator.aggregation.TDigestAggregationFunction;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestState;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateFactory;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateSerializer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Collectors;

public abstract class StatisticalDigestAggregationFunction
extends SqlAggregationFunction {
    private static final long DEFAULT_WEIGHT = 1L;
    private final String name;
    private final String type;
    private final StatisticalDigestStateFactory factory;
    private static final MethodHandle T_DIGEST_INPUT_DOUBLE = Reflection.methodHandle(TDigestAggregationFunction.class, "inputDouble", StatisticalDigestState.class, Double.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle QUANTILE_DIGEST_INPUT_DOUBLE = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputDouble", StatisticalDigestState.class, Double.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle INPUT_REAL = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputReal", StatisticalDigestState.class, Long.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle INPUT_BIGINT = Reflection.methodHandle(QuantileDigestAggregationFunction.class, "inputBigint", StatisticalDigestState.class, Long.TYPE, Long.TYPE, Double.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(StatisticalDigestAggregationFunction.class, "combineState", StatisticalDigestState.class, StatisticalDigestState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(StatisticalDigestAggregationFunction.class, "evaluateFinal", StatisticalDigestStateSerializer.class, StatisticalDigestState.class, BlockBuilder.class);

    StatisticalDigestAggregationFunction(String name, String type, StatisticalDigestStateFactory factory, SqlFunctionVisibility visibility, TypeSignature ... typeSignatures) {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)name), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"V")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)(type + "(V)")), (List)ImmutableList.copyOf((Object[])typeSignatures), false), visibility);
        this.name = name;
        this.type = type;
        this.factory = factory;
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type valueType = boundVariables.getTypeVariable("V");
        Type outputType = functionAndTypeManager.getParameterizedType(this.type, (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        return this.generateAggregation(this.name, valueType, outputType, arity);
    }

    private BuiltInAggregationFunctionImplementation generateAggregation(String name, Type valueType, Type outputType, int arity) {
        DynamicClassLoader classLoader = new DynamicClassLoader(StatisticalDigestAggregationFunction.class.getClassLoader());
        List<Type> inputTypes = StatisticalDigestAggregationFunction.getInputTypes(valueType, arity);
        StatisticalDigestStateSerializer stateSerializer = new StatisticalDigestStateSerializer();
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(name, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), StatisticalDigestAggregationFunction.createInputParameterMetadata(inputTypes), this.getInputMethodHandle(valueType, arity), COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(stateSerializer), (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(StatisticalDigestState.class, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)this.factory)), outputType);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(name, inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, true, true, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<Type> getInputTypes(Type valueType, int arity) {
        switch (arity) {
            case 1: {
                return ImmutableList.of((Object)valueType);
            }
            case 2: {
                return ImmutableList.of((Object)valueType, (Object)BigintType.BIGINT);
            }
            case 3: {
                return ImmutableList.of((Object)valueType, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported number of arguments: %s", arity));
    }

    private MethodHandle getInputMethodHandle(Type valueType, int arity) {
        switch (this.type) {
            case "tdigest": {
                return this.getTDigestInputMethodHandle(valueType, arity);
            }
            case "qdigest": {
                return StatisticalDigestAggregationFunction.getQuantileDigestInputMethodHandle(valueType, arity);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("%s must be a statistical digest", this.type));
    }

    private MethodHandle getTDigestInputMethodHandle(Type valueType, int arity) {
        MethodHandle inputFunction;
        switch (valueType.getDisplayName()) {
            case "double": {
                inputFunction = T_DIGEST_INPUT_DOUBLE;
                break;
            }
            case "real": {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot operate on a t-digest with real numbers");
            }
            case "bigint": {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot operate on a t-digest with longs");
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type %s supplied", valueType.getDisplayName()));
            }
        }
        return StatisticalDigestAggregationFunction.addArguments(inputFunction, arity, 100.0);
    }

    private static MethodHandle getQuantileDigestInputMethodHandle(Type valueType, int arity) {
        MethodHandle inputFunction;
        switch (valueType.getDisplayName()) {
            case "double": {
                inputFunction = QUANTILE_DIGEST_INPUT_DOUBLE;
                break;
            }
            case "real": {
                inputFunction = INPUT_REAL;
                break;
            }
            case "bigint": {
                inputFunction = INPUT_BIGINT;
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported type %s supplied", valueType.getDisplayName()));
            }
        }
        return StatisticalDigestAggregationFunction.addArguments(inputFunction, arity, 0.01);
    }

    private static MethodHandle addArguments(MethodHandle inputFunction, int arity, double parameter) {
        switch (arity) {
            case 1: {
                return MethodHandles.insertArguments(inputFunction, 2, 1L, parameter);
            }
            case 2: {
                return MethodHandles.insertArguments(inputFunction, 3, parameter);
            }
            case 3: {
                return inputFunction;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Unsupported number of arguments: %s", arity));
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(List<Type> valueTypes) {
        return ImmutableList.builder().add((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE)).addAll((Iterable)valueTypes.stream().map(valueType -> new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, valueType)).collect(Collectors.toList())).build();
    }

    public static void combineState(StatisticalDigestState state, StatisticalDigestState otherState) {
        StatisticalDigest input = otherState.getStatisticalDigest();
        StatisticalDigest previous = state.getStatisticalDigest();
        if (previous == null) {
            state.setStatisticalDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    public static void evaluateFinal(StatisticalDigestStateSerializer serializer, StatisticalDigestState state, BlockBuilder out) {
        serializer.serialize(state, out);
    }
}

