/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.LookupSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Objects;

public class LookupJoinPageBuilder {
    private final IntArrayList probeIndexBuilder = new IntArrayList();
    private final PageBuilder buildPageBuilder;
    private final int buildOutputChannelCount;
    private int estimatedProbeBlockBytes;
    private int previousPosition = -1;
    private int estimatedProbeBytesPerRow = -1;
    private boolean isSequentialProbeIndices = true;

    public LookupJoinPageBuilder(List<Type> buildTypes) {
        this.buildPageBuilder = new PageBuilder(Objects.requireNonNull(buildTypes, "buildTypes is null"));
        this.buildOutputChannelCount = buildTypes.size();
    }

    public boolean isFull() {
        return (long)this.estimatedProbeBlockBytes + this.buildPageBuilder.getSizeInBytes() >= 0x100000L || this.buildPageBuilder.isFull();
    }

    public boolean isEmpty() {
        return this.probeIndexBuilder.isEmpty() && this.buildPageBuilder.isEmpty();
    }

    public void reset() {
        this.probeIndexBuilder.clear();
        this.buildPageBuilder.reset();
        this.estimatedProbeBlockBytes = 0;
        this.estimatedProbeBytesPerRow = -1;
        this.previousPosition = -1;
        this.isSequentialProbeIndices = true;
    }

    public void appendRow(JoinProbe probe, LookupSource lookupSource, long joinPosition) {
        this.appendProbeIndex(probe);
        this.buildPageBuilder.declarePosition();
        lookupSource.appendTo(joinPosition, this.buildPageBuilder, 0);
    }

    public void appendNullForBuild(JoinProbe probe) {
        this.appendProbeIndex(probe);
        this.buildPageBuilder.declarePosition();
        for (int i = 0; i < this.buildOutputChannelCount; ++i) {
            this.buildPageBuilder.getBlockBuilder(i).appendNull();
        }
    }

    public Page build(JoinProbe probe) {
        int i;
        int outputPositions = this.probeIndexBuilder.size();
        Verify.verify((this.buildPageBuilder.getPositionCount() == outputPositions ? 1 : 0) != 0);
        int[] probeOutputChannels = probe.getOutputChannels();
        Block[] blocks = new Block[probeOutputChannels.length + this.buildOutputChannelCount];
        Page probePage = probe.getPage();
        if (!this.isSequentialProbeIndices || outputPositions == 0) {
            int[] probeIndices = this.probeIndexBuilder.toIntArray();
            for (i = 0; i < probeOutputChannels.length; ++i) {
                blocks[i] = probePage.getBlock(probeOutputChannels[i]).getPositions(probeIndices, 0, outputPositions);
            }
        } else {
            int startRegion = this.probeIndexBuilder.getInt(0);
            Verify.verify((this.previousPosition - startRegion == outputPositions - 1 ? 1 : 0) != 0);
            boolean outputProbeBlocksDirectly = startRegion == 0 && outputPositions == probePage.getPositionCount();
            for (int i2 = 0; i2 < probeOutputChannels.length; ++i2) {
                Block block = probePage.getBlock(probeOutputChannels[i2]);
                if (!outputProbeBlocksDirectly) {
                    block = block.getRegion(startRegion, outputPositions);
                }
                blocks[i2] = block;
            }
        }
        int offset = probeOutputChannels.length;
        for (i = 0; i < this.buildOutputChannelCount; ++i) {
            blocks[offset + i] = this.buildPageBuilder.getBlockBuilder(i).build();
            Verify.verify((blocks[offset + i].getPositionCount() == outputPositions ? 1 : 0) != 0);
        }
        return new Page(outputPositions, blocks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("estimatedSize", (long)this.estimatedProbeBlockBytes + this.buildPageBuilder.getSizeInBytes()).add("positionCount", this.buildPageBuilder.getPositionCount()).toString();
    }

    private void appendProbeIndex(JoinProbe probe) {
        int position = probe.getPosition();
        Verify.verify((position >= 0 && this.previousPosition <= position ? 1 : 0) != 0);
        this.isSequentialProbeIndices &= position == this.previousPosition + 1 || this.previousPosition == -1;
        this.probeIndexBuilder.add(position);
        this.estimatedProbeBlockBytes += 4;
        if (this.previousPosition != position) {
            this.previousPosition = position;
            if (this.estimatedProbeBytesPerRow < 0) {
                this.estimatedProbeBytesPerRow = LookupJoinPageBuilder.computeEstimatedProbeBytesPerRow(probe);
            }
            this.estimatedProbeBlockBytes += this.estimatedProbeBytesPerRow;
        }
    }

    private static int computeEstimatedProbeBytesPerRow(JoinProbe probe) {
        Page probePage = probe.getPage();
        if (probePage.getPositionCount() == 0) {
            return 0;
        }
        int estimatedBytesPerRow = 0;
        for (int index : probe.getOutputChannels()) {
            estimatedBytesPerRow = (int)((long)estimatedBytesPerRow + probePage.getBlock(index).getSizeInBytes() / (long)probePage.getPositionCount());
        }
        return estimatedBytesPerRow;
    }
}

