/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.array.IntBigArray;
import com.facebook.presto.common.array.LongBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.aggregation.GroupByIdBlock;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.util.HashCollisionsEstimator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BigintGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BigintGroupByHash.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final List<Type> TYPES_WITH_RAW_HASH = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private final int hashChannel;
    private final boolean outputRawHash;
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private LongBigArray values;
    private IntBigArray groupIds;
    private int nullGroupId = -1;
    private final LongBigArray valuesByGroupId;
    private int nextGroupId;
    private long hashCollisions;
    private double expectedHashCollisions;
    private final UpdateMemory updateMemory;
    private long preallocatedMemoryInBytes;
    private long currentPageSizeInBytes;

    public BigintGroupByHash(int hashChannel, boolean outputRawHash, int expectedSize, UpdateMemory updateMemory) {
        Preconditions.checkArgument((hashChannel >= 0 ? 1 : 0) != 0, (Object)"hashChannel must be at least zero");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.hashChannel = hashChannel;
        this.outputRawHash = outputRawHash;
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = BigintGroupByHash.calculateMaxFill(this.hashCapacity);
        this.mask = this.hashCapacity - 1;
        this.values = new LongBigArray();
        this.values.ensureCapacity((long)this.hashCapacity);
        this.groupIds = new IntBigArray(-1);
        this.groupIds.ensureCapacity((long)this.hashCapacity);
        this.valuesByGroupId = new LongBigArray();
        this.valuesByGroupId.ensureCapacity((long)this.hashCapacity);
        this.updateMemory = Objects.requireNonNull(updateMemory, "updateMemory is null");
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.groupIds.sizeOf() + this.values.sizeOf() + this.valuesByGroupId.sizeOf() + this.preallocatedMemoryInBytes;
    }

    @Override
    public long getHashCollisions() {
        return this.hashCollisions;
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.expectedHashCollisions + HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
    }

    @Override
    public List<Type> getTypes() {
        return this.outputRawHash ? TYPES_WITH_RAW_HASH : TYPES;
    }

    @Override
    public int getGroupCount() {
        return this.nextGroupId;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkArgument((groupId >= 0 ? 1 : 0) != 0, (Object)"groupId is negative");
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset);
        if (groupId == this.nullGroupId) {
            blockBuilder.appendNull();
        } else {
            BigintType.BIGINT.writeLong(blockBuilder, this.valuesByGroupId.get((long)groupId));
        }
        if (this.outputRawHash) {
            BlockBuilder hashBlockBuilder = pageBuilder.getBlockBuilder(outputChannelOffset + 1);
            if (groupId == this.nullGroupId) {
                BigintType.BIGINT.writeLong(hashBlockBuilder, 0L);
            } else {
                BigintType.BIGINT.writeLong(hashBlockBuilder, BigintOperators.hashCode(this.valuesByGroupId.get((long)groupId)));
            }
        }
    }

    @Override
    public Work<?> addPage(Page page) {
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        return new AddPageWork(page.getBlock(this.hashChannel));
    }

    @Override
    public List<Page> getBufferedPages() {
        throw new UnsupportedOperationException("BigIntGroupByHash does not support getBufferedPages");
    }

    @Override
    public Work<GroupByIdBlock> getGroupIds(Page page) {
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        return new GetGroupIdsWork(page.getBlock(this.hashChannel));
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels) {
        Block block = page.getBlock(this.hashChannel);
        if (block.isNull(position)) {
            return this.nullGroupId >= 0;
        }
        long value = BigintType.BIGINT.getLong(block, position);
        long hashPosition = BigintGroupByHash.getHashPosition(value, this.mask);
        int groupId;
        while ((groupId = this.groupIds.get(hashPosition)) != -1) {
            if (value == this.values.get(hashPosition)) {
                return true;
            }
            hashPosition = hashPosition + 1L & (long)this.mask;
        }
        return false;
    }

    @Override
    public long getRawHash(int groupId) {
        return BigintType.hash((long)this.valuesByGroupId.get((long)groupId));
    }

    @Override
    @VisibleForTesting
    public int getCapacity() {
        return this.hashCapacity;
    }

    private int putIfAbsent(int position, Block block) {
        int groupId;
        if (block.isNull(position)) {
            if (this.nullGroupId < 0) {
                this.nullGroupId = this.nextGroupId++;
            }
            return this.nullGroupId;
        }
        long value = BigintType.BIGINT.getLong(block, position);
        long hashPosition = BigintGroupByHash.getHashPosition(value, this.mask);
        while ((groupId = this.groupIds.get(hashPosition)) != -1) {
            if (value == this.values.get(hashPosition)) {
                return groupId;
            }
            hashPosition = hashPosition + 1L & (long)this.mask;
            ++this.hashCollisions;
        }
        return this.addNewGroup(hashPosition, value);
    }

    private int addNewGroup(long hashPosition, long value) {
        int groupId = this.nextGroupId++;
        this.values.set(hashPosition, value);
        this.valuesByGroupId.set((long)groupId, value);
        this.groupIds.set(hashPosition, groupId);
        if (this.needRehash()) {
            this.tryRehash();
        }
        return groupId;
    }

    private boolean tryRehash() {
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = Math.toIntExact(newCapacityLong);
        this.preallocatedMemoryInBytes = (long)newCapacity * 12L + (long)(BigintGroupByHash.calculateMaxFill(newCapacity) * 8) + this.currentPageSizeInBytes;
        if (!this.updateMemory.update()) {
            return false;
        }
        this.expectedHashCollisions += HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
        int newMask = newCapacity - 1;
        LongBigArray newValues = new LongBigArray();
        newValues.ensureCapacity((long)newCapacity);
        IntBigArray newGroupIds = new IntBigArray(-1);
        newGroupIds.ensureCapacity((long)newCapacity);
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            if (groupId == this.nullGroupId) continue;
            long value = this.valuesByGroupId.get((long)groupId);
            long hashPosition = BigintGroupByHash.getHashPosition(value, newMask);
            while (newGroupIds.get(hashPosition) != -1) {
                hashPosition = hashPosition + 1L & (long)newMask;
                ++this.hashCollisions;
            }
            newValues.set(hashPosition, value);
            newGroupIds.set(hashPosition, groupId);
        }
        this.mask = newMask;
        this.hashCapacity = newCapacity;
        this.maxFill = BigintGroupByHash.calculateMaxFill(this.hashCapacity);
        this.values = newValues;
        this.groupIds = newGroupIds;
        this.valuesByGroupId.ensureCapacity((long)this.maxFill);
        this.preallocatedMemoryInBytes = 0L;
        this.updateMemory.update();
        return true;
    }

    private boolean needRehash() {
        return this.nextGroupId >= this.maxFill;
    }

    private static long getHashPosition(long rawHash, int mask) {
        return HashCommon.murmurHash3((long)rawHash) & (long)mask;
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private class GetGroupIdsWork
    implements Work<GroupByIdBlock> {
        private final BlockBuilder blockBuilder;
        private final Block block;
        private boolean finished;
        private int lastPosition;

        public GetGroupIdsWork(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(block.getPositionCount());
        }

        @Override
        public boolean process() {
            int positionCount = this.block.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (BigintGroupByHash.this.needRehash() && !BigintGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !BigintGroupByHash.this.needRehash()) {
                BigintType.BIGINT.writeLong(this.blockBuilder, (long)BigintGroupByHash.this.putIfAbsent(this.lastPosition, this.block));
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public GroupByIdBlock getResult() {
            Preconditions.checkState((this.lastPosition == this.block.getPositionCount() ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return new GroupByIdBlock((long)BigintGroupByHash.this.nextGroupId, this.blockBuilder.build());
        }
    }

    private class AddPageWork
    implements Work<Void> {
        private final Block block;
        private int lastPosition;

        public AddPageWork(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
        }

        @Override
        public boolean process() {
            int positionCount = this.block.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            if (BigintGroupByHash.this.needRehash() && !BigintGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !BigintGroupByHash.this.needRehash()) {
                BigintGroupByHash.this.putIfAbsent(this.lastPosition, this.block);
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }
}

