/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SerializedPageReference {
    private static final AtomicIntegerFieldUpdater<SerializedPageReference> REFERENCE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SerializedPageReference.class, "referenceCount");
    private final SerializedPage serializedPage;
    private final Lifespan lifespan;
    private volatile int referenceCount;

    public SerializedPageReference(SerializedPage serializedPage, int referenceCount, Lifespan lifespan) {
        this.serializedPage = Objects.requireNonNull(serializedPage, "page is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
        this.referenceCount = referenceCount;
        Preconditions.checkArgument((referenceCount > 0 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
    }

    public void addReference() {
        int oldReferences = REFERENCE_COUNT_UPDATER.getAndIncrement(this);
        Preconditions.checkState((oldReferences > 0 ? 1 : 0) != 0, (Object)"Page has already been dereferenced");
    }

    public SerializedPage getSerializedPage() {
        return this.serializedPage;
    }

    public int getPositionCount() {
        return this.serializedPage.getPositionCount();
    }

    public long getRetainedSizeInBytes() {
        return this.serializedPage.getRetainedSizeInBytes();
    }

    private boolean dereferencePage() {
        int remainingReferences = REFERENCE_COUNT_UPDATER.decrementAndGet(this);
        Preconditions.checkState((remainingReferences >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
        return remainingReferences == 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("referenceCount", this.referenceCount).toString();
    }

    public static void dereferencePages(List<SerializedPageReference> serializedPageReferences, PagesReleasedListener onPagesReleased) {
        Objects.requireNonNull(onPagesReleased, "onPagesReleased is null");
        if (Objects.requireNonNull(serializedPageReferences, "serializedPageReferences is null").isEmpty()) {
            return;
        }
        Lifespan currentLifespan = null;
        int currentLifespanPages = 0;
        long releasedMemoryBytes = 0L;
        for (SerializedPageReference serializedPageReference : serializedPageReferences) {
            if (!serializedPageReference.dereferencePage()) continue;
            if (!serializedPageReference.lifespan.equals(currentLifespan)) {
                if (currentLifespan != null) {
                    onPagesReleased.onPagesReleased(currentLifespan, currentLifespanPages, releasedMemoryBytes);
                }
                currentLifespan = serializedPageReference.lifespan;
                currentLifespanPages = 0;
                releasedMemoryBytes = 0L;
            }
            ++currentLifespanPages;
            releasedMemoryBytes += serializedPageReference.getRetainedSizeInBytes();
        }
        if (currentLifespan != null) {
            onPagesReleased.onPagesReleased(currentLifespan, currentLifespanPages, releasedMemoryBytes);
        }
    }

    static interface PagesReleasedListener {
        public void onPagesReleased(Lifespan var1, int var2, long var3);
    }
}

