/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class DiscardingOutputBuffer
implements OutputBuffer {
    private static final ListenableFuture<?> NON_BLOCKED = Futures.immediateFuture(null);
    private final OutputBuffers outputBuffers;
    private final StateMachine<BufferState> state;
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();

    public DiscardingOutputBuffer(OutputBuffers outputBuffers, StateMachine<BufferState> state) {
        this.outputBuffers = Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        this.state = Objects.requireNonNull(state, "state is null");
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.state.get();
        return new OutputBufferInfo("DISCARD", state, state.canAddBuffers(), state.canAddPages(), 0L, 0L, this.totalRowsAdded.get(), this.totalPagesAdded.get(), (List<BufferInfo>)ImmutableList.of());
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    @Override
    public double getUtilization() {
        return 0.0;
    }

    @Override
    public boolean isOverutilized() {
        return false;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        if (this.state.get().isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
            return;
        }
        this.outputBuffers.checkValidTransition(newOutputBuffers);
    }

    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
        throw new UnsupportedOperationException("DiscardingOutputBuffer must not have any active readers");
    }

    @Override
    public void acknowledge(OutputBuffers.OutputBufferId bufferId, long token) {
        throw new UnsupportedOperationException("DiscardingOutputBuffer must not have any active readers");
    }

    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
    }

    @Override
    public ListenableFuture<?> isFull() {
        return NON_BLOCKED;
    }

    @Override
    public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
        long rowCount = pages.stream().mapToLong(SerializedPage::getPositionCount).sum();
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(pages.size());
    }

    @Override
    public void enqueue(Lifespan lifespan, int partition, List<SerializedPage> pages) {
        Preconditions.checkState((partition == 0 ? 1 : 0) != 0, (Object)"Expected partition number to be zero");
        this.enqueue(lifespan, pages);
    }

    @Override
    public void setNoMorePages() {
        this.state.set(BufferState.FINISHED);
    }

    @Override
    public void destroy() {
        this.state.setIf(BufferState.FINISHED, oldState -> !oldState.isTerminal());
    }

    @Override
    public void fail() {
        this.state.setIf(BufferState.FAILED, oldState -> !oldState.isTerminal());
    }

    @Override
    public void setNoMorePagesForLifespan(Lifespan lifespan) {
    }

    @Override
    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
    }

    @Override
    public boolean isFinishedForLifespan(Lifespan lifespan) {
        return true;
    }

    @Override
    public long getPeakMemoryUsage() {
        return 0L;
    }
}

