/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeoutThread
implements AutoCloseable {
    private final Future<?> future;

    public TimeoutThread(Thread thread, ScheduledExecutorService executor, Duration timeout) {
        Objects.requireNonNull(thread, "thread is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(timeout, "timeout is null");
        this.future = executor.schedule(thread::interrupt, timeout.roundTo(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() {
        this.future.cancel(true);
    }
}

