/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SessionTransactionControlTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Isolation;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.TransactionAccessMode;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class StartTransactionTask
implements SessionTransactionControlTask<StartTransaction> {
    @Override
    public String getName() {
        return "START TRANSACTION";
    }

    @Override
    public ListenableFuture<?> execute(StartTransaction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        if (!session.isClientTransactionSupport()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INCOMPATIBLE_CLIENT, "Client does not support transactions");
        }
        if (session.getTransactionId().isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Nested transactions not supported");
        }
        Optional<IsolationLevel> isolationLevel = StartTransactionTask.extractIsolationLevel(statement);
        Optional<Boolean> readOnly = StartTransactionTask.extractReadOnly(statement);
        TransactionId transactionId = transactionManager.beginTransaction(isolationLevel.orElse(TransactionManager.DEFAULT_ISOLATION), readOnly.orElse(false), false);
        stateMachine.setStartedTransactionId(transactionId);
        transactionManager.trySetInactive(transactionId);
        return Futures.immediateFuture(null);
    }

    private static Optional<IsolationLevel> extractIsolationLevel(StartTransaction startTransaction) {
        if (startTransaction.getTransactionModes().stream().filter(Isolation.class::isInstance).count() > 1L) {
            throw new SemanticException(SemanticErrorCode.INVALID_TRANSACTION_MODE, (Node)startTransaction, "Multiple transaction isolation levels specified", new Object[0]);
        }
        return startTransaction.getTransactionModes().stream().filter(Isolation.class::isInstance).map(Isolation.class::cast).map(Isolation::getLevel).map(StartTransactionTask::convertLevel).findFirst();
    }

    private static Optional<Boolean> extractReadOnly(StartTransaction startTransaction) {
        if (startTransaction.getTransactionModes().stream().filter(TransactionAccessMode.class::isInstance).count() > 1L) {
            throw new SemanticException(SemanticErrorCode.INVALID_TRANSACTION_MODE, (Node)startTransaction, "Multiple transaction read modes specified", new Object[0]);
        }
        return startTransaction.getTransactionModes().stream().filter(TransactionAccessMode.class::isInstance).map(TransactionAccessMode.class::cast).map(TransactionAccessMode::isReadOnly).findFirst();
    }

    private static IsolationLevel convertLevel(Isolation.Level level) {
        switch (level) {
            case SERIALIZABLE: {
                return IsolationLevel.SERIALIZABLE;
            }
            case REPEATABLE_READ: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case READ_COMMITTED: {
                return IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
        }
        throw new AssertionError((Object)("Unhandled isolation level: " + level));
    }
}

