/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.QueryId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public class StageId {
    private final QueryId queryId;
    private final int id;

    @JsonCreator
    public static StageId valueOf(String stageId) {
        List ids = QueryId.parseDottedId((String)stageId, (int)2, (String)"stageId");
        return StageId.valueOf(ids);
    }

    public static StageId valueOf(List<String> ids) {
        Preconditions.checkArgument((ids.size() == 2 ? 1 : 0) != 0, (String)"Expected two ids but got: %s", ids);
        return new StageId(new QueryId(ids.get(0)), Integer.parseInt(ids.get(1)));
    }

    public StageId(QueryId queryId, int id) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (String)"id is negative: %s", (int)id);
        this.id = id;
    }

    @ThriftConstructor
    public StageId(String queryId, int id) {
        this(QueryId.valueOf((String)queryId), id);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    @ThriftField(value=1, name="queryId")
    public String getQueryIdString() {
        return this.queryId.toString();
    }

    @ThriftField(value=2)
    public int getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.queryId + "." + this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.queryId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StageId other = (StageId)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.queryId, other.queryId);
    }
}

