/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SessionTransactionControlTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SetRole;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class SetRoleTask
implements SessionTransactionControlTask<SetRole> {
    @Override
    public String getName() {
        return "SET ROLE";
    }

    @Override
    public ListenableFuture<?> execute(SetRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        SelectedRole.Type type;
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.createCatalogName(session, (Node)statement);
        if (statement.getType() == SetRole.Type.ROLE) {
            accessControl.checkCanSetRole(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), statement.getRole().map(Identifier::getValueLowerCase).get(), catalog);
        }
        switch (statement.getType()) {
            case ROLE: {
                type = SelectedRole.Type.ROLE;
                break;
            }
            case ALL: {
                type = SelectedRole.Type.ALL;
                break;
            }
            case NONE: {
                type = SelectedRole.Type.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + statement.getType());
            }
        }
        stateMachine.addSetRole(catalog, new SelectedRole(type, statement.getRole().map(Identifier::getValueLowerCase)));
        return Futures.immediateFuture(null);
    }
}

