/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.FragmentStatsProvider;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import java.util.Objects;
import java.util.Optional;

public class RemoteSourceStatsRule
extends SimpleStatsRule<RemoteSourceNode> {
    private static final Pattern<RemoteSourceNode> PATTERN = Patterns.remoteSource();
    private final FragmentStatsProvider fragmentStatsProvider;

    public RemoteSourceStatsRule(FragmentStatsProvider fragmentStatsProvider, StatsNormalizer normalizer) {
        super(normalizer);
        this.fragmentStatsProvider = Objects.requireNonNull(fragmentStatsProvider, "metadata is null");
    }

    @Override
    public Pattern<RemoteSourceNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(RemoteSourceNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        QueryId queryId = session.getQueryId();
        PlanNodeStatsEstimateMath calculator = new PlanNodeStatsEstimateMath(SystemSessionProperties.shouldOptimizerUseHistograms(session));
        return node.getSourceFragmentIds().stream().map(fragmentId -> this.fragmentStatsProvider.getStats(queryId, (PlanFragmentId)fragmentId)).reduce(calculator::addStatsAndCollapseDistinctValues);
    }
}

