/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.sql.planner.CachingPlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class HistoryBasedStatisticsCacheManager {
    private final Map<QueryId, LoadingCache<PlanNodeWithHash, HistoricalPlanStatistics>> statisticsCache = new ConcurrentHashMap<QueryId, LoadingCache<PlanNodeWithHash, HistoricalPlanStatistics>>();
    private final Map<QueryId, Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo>> canonicalInfoCache = new ConcurrentHashMap<QueryId, Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo>>();
    private final Map<QueryId, Map<CachingPlanCanonicalInfoProvider.InputTableCacheKey, PlanStatistics>> inputTableStatistics = new ConcurrentHashMap<QueryId, Map<CachingPlanCanonicalInfoProvider.InputTableCacheKey, PlanStatistics>>();
    private final Set<QueryId> queryIdsRegistrationTimeOut = ConcurrentHashMap.newKeySet();
    private final Map<QueryId, Map<PlanCanonicalizationStrategy, String>> canonicalPlan = new ConcurrentHashMap<QueryId, Map<PlanCanonicalizationStrategy, String>>();
    private final Map<QueryId, PlanNode> statsEquivalentPlanRootNode = new ConcurrentHashMap<QueryId, PlanNode>();

    public LoadingCache<PlanNodeWithHash, HistoricalPlanStatistics> getStatisticsCache(QueryId queryId, final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, final long timeoutInMilliSeconds) {
        return this.statisticsCache.computeIfAbsent(queryId, ignored -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<PlanNodeWithHash, HistoricalPlanStatistics>(){

            public HistoricalPlanStatistics load(PlanNodeWithHash key) {
                return this.loadAll(Collections.singleton(key)).values().stream().findAny().orElseGet(HistoricalPlanStatistics::empty);
            }

            public Map<PlanNodeWithHash, HistoricalPlanStatistics> loadAll(Iterable<? extends PlanNodeWithHash> keys) {
                HashMap<PlanNodeWithHash, HistoricalPlanStatistics> statistics = new HashMap<PlanNodeWithHash, HistoricalPlanStatistics>(((HistoryBasedPlanStatisticsProvider)historyBasedPlanStatisticsProvider.get()).getStats((List)ImmutableList.copyOf(keys), timeoutInMilliSeconds));
                for (PlanNodeWithHash planNodeWithHash : keys) {
                    statistics.putIfAbsent(planNodeWithHash, HistoricalPlanStatistics.empty());
                }
                return ImmutableMap.copyOf(statistics);
            }
        }));
    }

    public Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo> getCanonicalInfoCache(QueryId queryId) {
        return this.canonicalInfoCache.computeIfAbsent(queryId, ignored -> new ConcurrentHashMap());
    }

    public Map<CachingPlanCanonicalInfoProvider.InputTableCacheKey, PlanStatistics> getInputTableStatistics(QueryId queryId) {
        return this.inputTableStatistics.computeIfAbsent(queryId, ignored -> new ConcurrentHashMap());
    }

    public Map<PlanCanonicalizationStrategy, String> getCanonicalPlan(QueryId queryId) {
        return this.canonicalPlan.computeIfAbsent(queryId, ignored -> new ConcurrentHashMap());
    }

    public void setStatsEquivalentPlanRootNode(QueryId queryId, PlanNode plan) {
        this.statsEquivalentPlanRootNode.put(queryId, plan);
    }

    public Optional<PlanNode> getStatsEquivalentPlanRootNode(QueryId queryId) {
        if (this.statsEquivalentPlanRootNode.containsKey(queryId)) {
            return Optional.of(this.statsEquivalentPlanRootNode.get(queryId));
        }
        return Optional.empty();
    }

    public void invalidate(QueryId queryId) {
        this.statisticsCache.remove(queryId);
        this.canonicalInfoCache.remove(queryId);
        this.inputTableStatistics.remove(queryId);
        this.queryIdsRegistrationTimeOut.remove(queryId);
        this.canonicalPlan.remove(queryId);
        this.statsEquivalentPlanRootNode.remove(queryId);
    }

    @VisibleForTesting
    public Map<QueryId, Map<CachingPlanCanonicalInfoProvider.CacheKey, PlanNodeCanonicalInfo>> getCanonicalInfoCache() {
        return this.canonicalInfoCache;
    }

    public boolean historyBasedQueryRegistrationTimeout(QueryId queryId) {
        return this.queryIdsRegistrationTimeOut.contains(queryId);
    }

    public void setHistoryBasedQueryRegistrationTimeout(QueryId queryId) {
        this.queryIdsRegistrationTimeOut.add(queryId);
    }
}

