/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.google.common.math.DoubleMath;

public class HistogramCalculator {
    private HistogramCalculator() {
    }

    public static Estimate calculateFilterFactor(StatisticRange range, ConnectorHistogram histogram, Estimate totalDistinctValues, boolean useHeuristics) {
        boolean openHigh = range.getOpenHigh();
        boolean openLow = range.getOpenLow();
        Estimate min = histogram.inverseCumulativeProbability(0.0);
        Estimate max = histogram.inverseCumulativeProbability(1.0);
        if (!max.isUnknown() && (!openHigh ? max.getValue() < range.getLow() : max.getValue() <= range.getLow()) || !min.isUnknown() && (openLow ? min.getValue() >= range.getHigh() : min.getValue() > range.getHigh())) {
            return Estimate.of((double)0.0);
        }
        if (max.isUnknown() && !min.isUnknown() || !max.isUnknown() && min.isUnknown()) {
            if (!useHeuristics) {
                return Estimate.unknown();
            }
            if (range.length() == 0.0) {
                return totalDistinctValues.map(distinct -> 1.0 / distinct);
            }
            if (Double.isFinite(range.length())) {
                return Estimate.of((double)0.25);
            }
            return Estimate.of((double)0.5);
        }
        Estimate lowPercentile = histogram.cumulativeProbability(range.getLow(), openLow);
        Estimate highPercentile = histogram.cumulativeProbability(range.getHigh(), !openHigh);
        if (lowPercentile.isUnknown() || highPercentile.isUnknown()) {
            if (!useHeuristics) {
                return Estimate.unknown();
            }
            if (totalDistinctValues.equals((Object)Estimate.zero()) || range.getDistinctValuesCount() == 0.0) {
                return Estimate.of((double)0.0);
            }
            if ((lowPercentile.isUnknown() && !highPercentile.isUnknown() || !lowPercentile.isUnknown() && highPercentile.isUnknown()) && Double.isFinite(range.length())) {
                return Estimate.of((double)0.25);
            }
            if (range.length() == 0.0) {
                return totalDistinctValues.map(distinct -> 1.0 / distinct);
            }
            if (!Double.isNaN(range.getDistinctValuesCount())) {
                return totalDistinctValues.map(distinct -> Math.min(1.0, range.getDistinctValuesCount() / distinct));
            }
            return Estimate.of((double)0.5);
        }
        if (lowPercentile.equals((Object)highPercentile)) {
            if (!useHeuristics) {
                return Estimate.zero();
            }
            return totalDistinctValues.map(distinct -> 1.0 / distinct);
        }
        if (lowPercentile.equals((Object)Estimate.zero()) && highPercentile.equals((Object)Estimate.of((double)1.0)) && min.isUnknown() && max.isUnknown()) {
            if (!useHeuristics) {
                return Estimate.unknown();
            }
            return totalDistinctValues.flatMap(totalDistinct -> {
                if (DoubleMath.fuzzyEquals((double)totalDistinct, (double)0.0, (double)1.0E-6)) {
                    return Estimate.of((double)1.0);
                }
                return Estimate.of((double)Math.min(1.0, range.getDistinctValuesCount() / totalDistinct));
            }).or(() -> Estimate.of((double)0.5));
        }
        return lowPercentile.flatMap(lowPercent -> highPercentile.map(highPercent -> highPercent - lowPercent));
    }
}

