/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.session.ResourceEstimates;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManager;
import com.facebook.presto.spi.tracing.Tracer;
import com.facebook.presto.sql.analyzer.CTEInformationCollector;
import com.facebook.presto.sql.planner.optimizations.OptimizerInformationCollector;
import com.facebook.presto.sql.planner.optimizations.OptimizerResultCollector;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;

public final class Session {
    private final QueryId queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final Identity identity;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Optional<String> traceToken;
    private final Set<String> clientTags;
    private final ResourceEstimates resourceEstimates;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<ConnectorId, Map<String, String>> connectorProperties;
    private final Map<String, Map<String, String>> unprocessedCatalogProperties;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<String, String> preparedStatements;
    private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;
    private final AccessControlContext context;
    private final Optional<Tracer> tracer;
    private final WarningCollector warningCollector;
    private final RuntimeStats runtimeStats;
    private final OptimizerInformationCollector optimizerInformationCollector = new OptimizerInformationCollector();
    private final OptimizerResultCollector optimizerResultCollector = new OptimizerResultCollector();
    private final CTEInformationCollector cteInformationCollector = new CTEInformationCollector();
    private final Map<PlanNodeId, PlanNodeStatsEstimate> planNodeStatsMap = new HashMap<PlanNodeId, PlanNodeStatsEstimate>();
    private final Map<PlanNodeId, PlanCostEstimate> planNodeCostMap = new HashMap<PlanNodeId, PlanCostEstimate>();

    public Session(QueryId queryId, Optional<TransactionId> transactionId, boolean clientTransactionSupport, Identity identity, Optional<String> source, Optional<String> catalog, Optional<String> schema, Optional<String> traceToken, TimeZoneKey timeZoneKey, Locale locale, Optional<String> remoteUserAddress, Optional<String> userAgent, Optional<String> clientInfo, Set<String> clientTags, ResourceEstimates resourceEstimates, long startTime, Map<String, String> systemProperties, Map<ConnectorId, Map<String, String>> connectorProperties, Map<String, Map<String, String>> unprocessedCatalogProperties, SessionPropertyManager sessionPropertyManager, Map<String, String> preparedStatements, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, Optional<Tracer> tracer, WarningCollector warningCollector, RuntimeStats runtimeStats) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
        this.sessionFunctions = Objects.requireNonNull(sessionFunctions, "sessionFunctions is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        connectorProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.connectorProperties = catalogPropertiesBuilder.build();
        ImmutableMap.Builder unprocessedCatalogPropertiesBuilder = ImmutableMap.builder();
        unprocessedCatalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)unprocessedCatalogPropertiesBuilder).put(arg_0));
        this.unprocessedCatalogProperties = unprocessedCatalogPropertiesBuilder.build();
        Preconditions.checkArgument((!transactionId.isPresent() || unprocessedCatalogProperties.isEmpty() ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
        Preconditions.checkArgument((catalog.isPresent() || !schema.isPresent() ? 1 : 0) != 0, (Object)"schema is set but catalog is not");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
        this.context = new AccessControlContext(queryId, clientInfo, clientTags, source, warningCollector, runtimeStats);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public String getUser() {
        return this.identity.getUser();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public TransactionId getRequiredTransactionId() {
        Preconditions.checkState((boolean)this.transactionId.isPresent(), (Object)"Not in a transaction");
        return this.transactionId.get();
    }

    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    public <T> T getSystemProperty(String name, Class<T> type) {
        return this.sessionPropertyManager.decodeSystemPropertyValue(name, this.systemProperties.get(name), type);
    }

    public Map<ConnectorId, Map<String, String>> getConnectorProperties() {
        return this.connectorProperties;
    }

    public Map<String, String> getConnectorProperties(ConnectorId connectorId) {
        return this.connectorProperties.getOrDefault(connectorId, (Map<String, String>)ImmutableMap.of());
    }

    public Map<String, Map<String, String>> getUnprocessedCatalogProperties() {
        return this.unprocessedCatalogProperties;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getPreparedStatement(String name) {
        String sql = this.preparedStatements.get(name);
        Failures.checkCondition(sql != null, (ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + name, new Object[0]);
        return sql;
    }

    public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions() {
        return this.sessionFunctions;
    }

    public AccessControlContext getAccessControlContext() {
        return this.context;
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public Optional<Tracer> getTracer() {
        return this.tracer;
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public OptimizerInformationCollector getOptimizerInformationCollector() {
        return this.optimizerInformationCollector;
    }

    public OptimizerResultCollector getOptimizerResultCollector() {
        return this.optimizerResultCollector;
    }

    public CTEInformationCollector getCteInformationCollector() {
        return this.cteInformationCollector;
    }

    public Map<PlanNodeId, PlanNodeStatsEstimate> getPlanNodeStatsMap() {
        return this.planNodeStatsMap;
    }

    public Map<PlanNodeId, PlanCostEstimate> getPlanNodeCostMap() {
        return this.planNodeCostMap;
    }

    public Session beginTransactionId(TransactionId transactionId, TransactionManager transactionManager, AccessControl accessControl) {
        Objects.requireNonNull(transactionId, "transactionId is null");
        Preconditions.checkArgument((!this.transactionId.isPresent() ? 1 : 0) != 0, (Object)"Session already has an active transaction");
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            accessControl.checkCanSetSystemSessionProperty(this.identity, this.context, entry.getKey());
            this.sessionPropertyManager.validateSystemSessionProperty(entry.getKey(), entry.getValue());
        }
        ImmutableMap.Builder connectorProperties = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : this.unprocessedCatalogProperties.entrySet()) {
            String catalogName = entry.getKey();
            Map<String, String> catalogProperties = entry.getValue();
            if (catalogProperties.isEmpty()) continue;
            ConnectorId connectorId = transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Session property catalog does not exist: " + catalogName)).getConnectorId();
            for (Map.Entry<String, String> property : catalogProperties.entrySet()) {
                accessControl.checkCanSetCatalogSessionProperty(transactionId, this.identity, this.context, catalogName, property.getKey());
                this.sessionPropertyManager.validateCatalogSessionProperty(connectorId, catalogName, property.getKey(), property.getValue());
            }
            connectorProperties.put((Object)connectorId, catalogProperties);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.identity.getRoles().entrySet()) {
            String catalogName = (String)entry.getKey();
            SelectedRole role = (SelectedRole)entry.getValue();
            ConnectorId connectorId = transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalogName)).getConnectorId();
            if (role.getType() == SelectedRole.Type.ROLE) {
                accessControl.checkCanSetRole(transactionId, this.identity, this.context, (String)role.getRole().get(), catalogName);
            }
            builder.put((Object)connectorId.getCatalogName(), (Object)role);
            String informationSchemaCatalogName = ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId).getCatalogName();
            if (transactionManager.getCatalogNames(transactionId).containsKey(informationSchemaCatalogName)) {
                builder.put((Object)ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId).getCatalogName(), (Object)role);
            }
            String systemTablesCatalogName = ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId).getCatalogName();
            if (!transactionManager.getCatalogNames(transactionId).containsKey(systemTablesCatalogName)) continue;
            builder.put((Object)ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId).getCatalogName(), (Object)role);
        }
        return new Session(this.queryId, Optional.of(transactionId), this.clientTransactionSupport, new Identity(this.identity.getUser(), this.identity.getPrincipal(), (Map)builder.build(), this.identity.getExtraCredentials(), this.identity.getExtraAuthenticators(), this.identity.getSelectedUser(), this.identity.getReasonForSelect()), this.source, this.catalog, this.schema, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.resourceEstimates, this.startTime, this.systemProperties, (Map<ConnectorId, Map<String, String>>)connectorProperties.build(), (Map<String, Map<String, String>>)ImmutableMap.of(), this.sessionPropertyManager, this.preparedStatements, this.sessionFunctions, this.tracer, this.warningCollector, this.runtimeStats);
    }

    public Session withDefaultProperties(SessionPropertyConfigurationManager.SystemSessionPropertyConfiguration systemPropertyConfiguration, Map<String, Map<String, String>> catalogPropertyDefaults) {
        Objects.requireNonNull(systemPropertyConfiguration, "systemPropertyConfiguration is null");
        Objects.requireNonNull(catalogPropertyDefaults, "catalogPropertyDefaults is null");
        Preconditions.checkState((!this.transactionId.isPresent() && this.connectorProperties.isEmpty() ? 1 : 0) != 0, (Object)"Session properties cannot be overridden once a transaction is active");
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.putAll(systemPropertyConfiguration.systemPropertyDefaults);
        systemProperties.putAll(this.systemProperties);
        systemProperties.putAll(systemPropertyConfiguration.systemPropertyOverrides);
        Map<String, Map<String, String>> connectorProperties = catalogPropertyDefaults.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), new HashMap((Map)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, Map<String, String>> catalogProperties : this.unprocessedCatalogProperties.entrySet()) {
            String catalog = catalogProperties.getKey();
            for (Map.Entry<String, String> entry2 : catalogProperties.getValue().entrySet()) {
                connectorProperties.computeIfAbsent(catalog, id -> new HashMap()).put(entry2.getKey(), entry2.getValue());
            }
        }
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.resourceEstimates, this.startTime, systemProperties, (Map<ConnectorId, Map<String, String>>)ImmutableMap.of(), connectorProperties, this.sessionPropertyManager, this.preparedStatements, this.sessionFunctions, this.tracer, this.warningCollector, this.runtimeStats);
    }

    public ConnectorSession toConnectorSession() {
        return new FullConnectorSession(this, this.identity.toConnectorIdentity());
    }

    public SqlFunctionProperties getSqlFunctionProperties() {
        boolean legacyJsonCast = this.sessionPropertyManager.decodeSystemPropertyValue("legacy_json_cast", null, Boolean.class);
        return SqlFunctionProperties.builder().setTimeZoneKey(this.timeZoneKey).setLegacyRowFieldOrdinalAccessEnabled(SystemSessionProperties.isLegacyRowFieldOrdinalAccessEnabled(this)).setLegacyTimestamp(SystemSessionProperties.isLegacyTimestamp(this)).setLegacyMapSubscript(SystemSessionProperties.isLegacyMapSubscript(this)).setParseDecimalLiteralAsDouble(SystemSessionProperties.isParseDecimalLiteralsAsDouble(this)).setSessionStartTime(this.getStartTime()).setSessionLocale(this.getLocale()).setSessionUser(this.getUser()).setFieldNamesInJsonCastEnabled(SystemSessionProperties.isFieldNameInJsonCastEnabled(this)).setLegacyJsonCast(legacyJsonCast).setExtraCredentials(this.identity.getExtraCredentials()).setWarnOnCommonNanPatterns(SystemSessionProperties.warnOnCommonNanPatterns(this)).build();
    }

    public ConnectorSession toConnectorSession(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        return new FullConnectorSession(this, this.identity.toConnectorIdentity(connectorId.getCatalogName()), this.connectorProperties.getOrDefault(connectorId, (Map<String, String>)ImmutableMap.of()), connectorId, connectorId.getCatalogName(), this.sessionPropertyManager);
    }

    public SessionRepresentation toSessionRepresentation() {
        return new SessionRepresentation(this.queryId.toString(), this.transactionId, this.clientTransactionSupport, this.identity.getUser(), this.identity.getPrincipal().map(Principal::toString), this.source, this.catalog, this.schema, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.resourceEstimates, this.startTime, this.systemProperties, this.connectorProperties, this.unprocessedCatalogProperties, this.identity.getRoles(), this.preparedStatements, this.sessionFunctions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("transactionId", this.transactionId).add("user", (Object)this.getUser()).add("principal", this.getIdentity().getPrincipal().orElse(null)).add("source", this.source.orElse(null)).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("traceToken", this.traceToken.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", this.remoteUserAddress.orElse(null)).add("userAgent", this.userAgent.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).add("clientTags", this.clientTags).add("resourceEstimates", (Object)this.resourceEstimates).add("startTime", this.startTime).omitNullValues().toString();
    }

    public static SessionBuilder builder(SessionPropertyManager sessionPropertyManager) {
        return new SessionBuilder(sessionPropertyManager);
    }

    public static SessionBuilder builder(Session session) {
        return new SessionBuilder(session);
    }

    public static class ResourceEstimateBuilder {
        private Optional<Duration> executionTime = Optional.empty();
        private Optional<Duration> cpuTime = Optional.empty();
        private Optional<DataSize> peakMemory = Optional.empty();
        private Optional<DataSize> peakTaskMemory = Optional.empty();

        public ResourceEstimateBuilder setExecutionTime(Duration executionTime) {
            this.executionTime = Optional.of(executionTime);
            return this;
        }

        public ResourceEstimateBuilder setCpuTime(Duration cpuTime) {
            this.cpuTime = Optional.of(cpuTime);
            return this;
        }

        public ResourceEstimateBuilder setPeakMemory(DataSize peakMemory) {
            this.peakMemory = Optional.of(peakMemory);
            return this;
        }

        public ResourceEstimateBuilder setPeakTaskMemory(DataSize peakTaskMemory) {
            this.peakTaskMemory = Optional.of(peakTaskMemory);
            return this;
        }

        public ResourceEstimates build() {
            return new ResourceEstimates(this.executionTime, this.cpuTime, this.peakMemory, this.peakTaskMemory);
        }
    }

    public static class SessionBuilder {
        private QueryId queryId;
        private TransactionId transactionId;
        private boolean clientTransactionSupport;
        private Identity identity;
        private String source;
        private String catalog;
        private String schema;
        private Optional<String> traceToken = Optional.empty();
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private String clientInfo;
        private Set<String> clientTags = ImmutableSet.of();
        private ResourceEstimates resourceEstimates;
        private Optional<Tracer> tracer = Optional.empty();
        private long startTime = System.currentTimeMillis();
        private final Map<String, String> systemProperties = new HashMap<String, String>();
        private final Map<ConnectorId, Map<String, String>> connectorProperties = new HashMap<ConnectorId, Map<String, String>>();
        private final Map<String, Map<String, String>> catalogSessionProperties = new HashMap<String, Map<String, String>>();
        private final SessionPropertyManager sessionPropertyManager;
        private final Map<String, String> preparedStatements = new HashMap<String, String>();
        private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions = new HashMap<SqlFunctionId, SqlInvokedFunction>();
        private WarningCollector warningCollector = WarningCollector.NOOP;
        private RuntimeStats runtimeStats = new RuntimeStats();

        private SessionBuilder(SessionPropertyManager sessionPropertyManager) {
            this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        }

        private SessionBuilder(Session session) {
            Objects.requireNonNull(session, "session is null");
            Preconditions.checkArgument((!session.getTransactionId().isPresent() ? 1 : 0) != 0, (Object)"Session builder cannot be created from a session in a transaction");
            this.sessionPropertyManager = session.sessionPropertyManager;
            this.queryId = session.queryId;
            this.transactionId = session.transactionId.orElse(null);
            this.clientTransactionSupport = session.clientTransactionSupport;
            this.identity = session.identity;
            this.source = session.source.orElse(null);
            this.catalog = session.catalog.orElse(null);
            this.schema = session.schema.orElse(null);
            this.traceToken = Objects.requireNonNull(session.traceToken, "traceToken is null");
            this.timeZoneKey = session.timeZoneKey;
            this.locale = session.locale;
            this.remoteUserAddress = session.remoteUserAddress.orElse(null);
            this.userAgent = session.userAgent.orElse(null);
            this.clientInfo = session.clientInfo.orElse(null);
            this.clientTags = ImmutableSet.copyOf((Collection)session.clientTags);
            this.startTime = session.startTime;
            this.systemProperties.putAll(session.systemProperties);
            session.unprocessedCatalogProperties.forEach((key, value) -> {
                Map cfr_ignored_0 = this.catalogSessionProperties.put((String)key, new HashMap(value));
            });
            this.preparedStatements.putAll(session.preparedStatements);
            this.sessionFunctions.putAll(session.sessionFunctions);
            this.tracer = Objects.requireNonNull(session.tracer, "tracer is null");
            this.warningCollector = Objects.requireNonNull(session.warningCollector, "warningCollector is null");
            this.runtimeStats = Objects.requireNonNull(session.runtimeStats, "runtimeStats is null");
        }

        public SessionBuilder setQueryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            return this;
        }

        public SessionBuilder setTransactionId(TransactionId transactionId) {
            Preconditions.checkArgument((boolean)this.catalogSessionProperties.isEmpty(), (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.transactionId = transactionId;
            return this;
        }

        public SessionBuilder setTracer(Optional<Tracer> tracer) {
            this.tracer = Objects.requireNonNull(tracer, "tracer is null");
            return this;
        }

        public SessionBuilder setClientTransactionSupport() {
            this.clientTransactionSupport = true;
            return this;
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setTraceToken(Optional<String> traceToken) {
            this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
            return this;
        }

        public SessionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public SessionBuilder setClientInfo(String clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        public SessionBuilder setClientTags(Set<String> clientTags) {
            this.clientTags = ImmutableSet.copyOf(clientTags);
            return this;
        }

        public SessionBuilder setResourceEstimates(ResourceEstimates resourceEstimates) {
            this.resourceEstimates = resourceEstimates;
            return this;
        }

        public SessionBuilder setSystemProperty(String propertyName, String propertyValue) {
            this.systemProperties.put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder setConnectionProperty(ConnectorId connectorId, String propertyName, String propertyValue) {
            this.connectorProperties.computeIfAbsent(connectorId, id -> new HashMap()).put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder setCatalogSessionProperty(String catalogName, String propertyName, String propertyValue) {
            Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
            return this;
        }

        public SessionBuilder addPreparedStatement(String statementName, String query) {
            this.preparedStatements.put(statementName, query);
            return this;
        }

        public SessionBuilder addSessionFunction(SqlFunctionId functionSignature, SqlInvokedFunction functionDefinition) {
            this.sessionFunctions.put(functionSignature, functionDefinition);
            return this;
        }

        public SessionBuilder setWarningCollector(WarningCollector warningCollector) {
            this.warningCollector = warningCollector;
            return this;
        }

        public SessionBuilder setRuntimeStats(RuntimeStats runtimeStats) {
            this.runtimeStats = runtimeStats;
            return this;
        }

        public <T> T getSystemProperty(String name, Class<T> type) {
            return this.sessionPropertyManager.decodeSystemPropertyValue(name, this.systemProperties.get(name), type);
        }

        public Session build() {
            return new Session(this.queryId, Optional.ofNullable(this.transactionId), this.clientTransactionSupport, this.identity, Optional.ofNullable(this.source), Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.traceToken, this.timeZoneKey, this.locale, Optional.ofNullable(this.remoteUserAddress), Optional.ofNullable(this.userAgent), Optional.ofNullable(this.clientInfo), this.clientTags, Optional.ofNullable(this.resourceEstimates).orElse(new ResourceEstimateBuilder().build()), this.startTime, this.systemProperties, this.connectorProperties, this.catalogSessionProperties, this.sessionPropertyManager, this.preparedStatements, this.sessionFunctions, this.tracer, this.warningCollector, this.runtimeStats);
        }
    }
}

