"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    QueryState: function() {
        return QueryState;
    },
    StageExecutionState: function() {
        return StageExecutionState;
    },
    RuntimeUnit: function() {
        return RuntimeUnit;
    },
    ErrorType: function() {
        return ErrorType;
    },
    QueryType: function() {
        return QueryType;
    }
});
var QueryState;
(function(QueryState) {
    QueryState["WAITING_FOR_PREREQUISITES"] = "WAITING_FOR_PREREQUISITES";
    QueryState["QUEUED"] = "QUEUED";
    QueryState["WAITING_FOR_RESOURCES"] = "WAITING_FOR_RESOURCES";
    QueryState["DISPATCHING"] = "DISPATCHING";
    QueryState["PLANNING"] = "PLANNING";
    QueryState["STARTING"] = "STARTING";
    QueryState["RUNNING"] = "RUNNING";
    QueryState["FINISHING"] = "FINISHING";
    QueryState["FINISHED"] = "FINISHED";
    QueryState["FAILED"] = "FAILED";
})(QueryState || (QueryState = {}));
var StageExecutionState;
(function(StageExecutionState) {
    StageExecutionState["PLANNED"] = "PLANNED";
    StageExecutionState["SCHEDULING"] = "SCHEDULING";
    StageExecutionState["FINISHED_TASK_SCHEDULING"] = "FINISHED_TASK_SCHEDULING";
    StageExecutionState["SCHEDULING_SPLITS"] = "SCHEDULING_SPLITS";
    StageExecutionState["SCHEDULED"] = "SCHEDULED";
    StageExecutionState["RUNNING"] = "RUNNING";
    StageExecutionState["FINISHED"] = "FINISHED";
    StageExecutionState["CANCELED"] = "CANCELED";
    StageExecutionState["ABORTED"] = "ABORTED";
    StageExecutionState["FAILED"] = "FAILED";
})(StageExecutionState || (StageExecutionState = {}));
var RuntimeUnit;
(function(RuntimeUnit) {
    RuntimeUnit["NONE"] = "NONE";
    RuntimeUnit["NANO"] = "NANO";
    RuntimeUnit["BYTE"] = "BYTE";
})(RuntimeUnit || (RuntimeUnit = {}));
var ErrorType;
(function(ErrorType) {
    ErrorType["USER_ERROR"] = "USER_ERROR";
    ErrorType["INTERNAL_ERROR"] = "INTERNAL_ERROR";
    ErrorType["INSUFFICIENT_RESOURCES"] = "INSUFFICIENT_RESOURCES";
    ErrorType["EXTERNAL"] = "EXTERNAL";
})(ErrorType || (ErrorType = {}));
var QueryType;
(function(QueryType) {
    QueryType["CREATE_TABLE_AS_SELECT"] = "CREATE_TABLE_AS_SELECT";
    QueryType["INSERT"] = "INSERT";
    QueryType["QUERY"] = "QUERY";
    QueryType["CREATE_VIEW"] = "CREATE_VIEW";
    QueryType["CREATE_TABLE"] = "CREATE_TABLE";
    QueryType["UNSUPPORTED"] = "UNSUPPORTED";
})(QueryType || (QueryType = {}));
