/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.Session;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DecimalParseResult;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DistinctType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.QuantifiedComparisonExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.UnresolvedSymbolExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.EnumLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.LegacyRowFieldOrdinalAccessUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Pattern;

public final class SqlToRowExpressionTranslator {
    private static final Pattern LIKE_PREFIX_MATCH_PATTERN = Pattern.compile("^[^%_]*%$");
    private static final Pattern LIKE_SUFFIX_MATCH_PATTERN = Pattern.compile("^%[^%_]*$");
    private static final Pattern LIKE_SIMPLE_EXISTS_PATTERN = Pattern.compile("^%[^%_]*%$");

    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, FunctionAndTypeManager functionAndTypeManager, Session session) {
        return SqlToRowExpressionTranslator.translate(expression, types, layout, functionAndTypeManager, session, new Context());
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, FunctionAndTypeManager functionAndTypeManager, Session session, Context context) {
        return SqlToRowExpressionTranslator.translate(expression, types, layout, functionAndTypeManager, Optional.of(session.getUser()), session.getTransactionId(), session.getSqlFunctionProperties(), session.getSessionFunctions(), context);
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, FunctionAndTypeManager functionAndTypeManager, Optional<String> user, Optional<TransactionId> transactionId, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, Context context) {
        Visitor visitor = new Visitor(types, layout, functionAndTypeManager, user, transactionId, sqlFunctionProperties, sessionFunctions);
        RowExpression result = visitor.process((Node)expression, context);
        Objects.requireNonNull(result, "translated expression is null");
        return result;
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Context> {
        private final Map<NodeRef<Expression>, Type> types;
        private final Map<VariableReferenceExpression, Integer> layout;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final FunctionAndTypeResolver functionAndTypeResolver;
        private final Optional<String> user;
        private final Optional<TransactionId> transactionId;
        private final SqlFunctionProperties sqlFunctionProperties;
        private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;
        private final FunctionResolution functionResolution;

        private Visitor(Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, FunctionAndTypeManager functionAndTypeManager, Optional<String> user, Optional<TransactionId> transactionId, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions) {
            this.types = Objects.requireNonNull(types, "types is null");
            this.layout = Objects.requireNonNull(layout);
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager);
            this.functionAndTypeResolver = functionAndTypeManager.getFunctionAndTypeResolver();
            this.user = Objects.requireNonNull(user);
            this.transactionId = Objects.requireNonNull(transactionId);
            this.sqlFunctionProperties = Objects.requireNonNull(sqlFunctionProperties);
            this.functionResolution = new FunctionResolution(this.functionAndTypeResolver);
            this.sessionFunctions = Objects.requireNonNull(sessionFunctions);
        }

        private Type getType(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        public RowExpression process(Node node, Context context) {
            if (!(node instanceof Expression)) {
                throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
            }
            Expression expression = (Expression)node;
            if (context.getRowExpressionMap().containsKey(expression)) {
                return context.getRowExpressionMap().get(expression);
            }
            RowExpression rowExpression = (RowExpression)super.process((Node)expression, (Object)context);
            context.put(expression, rowExpression);
            return rowExpression;
        }

        protected RowExpression visitExpression(Expression node, Context context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitIdentifier(Identifier node, Context context) {
            return new VariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)node), node.getValue(), this.getType((Expression)node));
        }

        protected RowExpression visitFieldReference(FieldReference node, Context context) {
            return Expressions.field(ExpressionTreeUtils.getSourceLocation((Node)node), node.getFieldIndex(), this.getType((Expression)node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Context context) {
            return Expressions.constantNull(ExpressionTreeUtils.getSourceLocation((Node)node), (Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Context context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Context context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return Expressions.constant(node.getValue(), (Type)IntegerType.INTEGER);
            }
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Context context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitDecimalLiteral(DecimalLiteral node, Context context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return Expressions.constant(parseResult.getObject(), (Type)parseResult.getType());
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Context context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice())));
        }

        protected RowExpression visitCharLiteral(CharLiteral node, Context context) {
            return Expressions.constant(node.getSlice(), (Type)CharType.createCharType((long)node.getValue().length()));
        }

        protected RowExpression visitBinaryLiteral(BinaryLiteral node, Context context) {
            return Expressions.constant(node.getValue(), (Type)VarbinaryType.VARBINARY);
        }

        protected RowExpression visitEnumLiteral(EnumLiteral node, Context context) {
            Type type;
            try {
                type = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            return Expressions.constant(node.getValue(), type);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Context context) {
            Type type;
            try {
                type = this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            try {
                if (TinyintType.TINYINT.equals((Object)type)) {
                    return Expressions.constant(Byte.parseByte(node.getValue()), (Type)TinyintType.TINYINT);
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    return Expressions.constant(Short.parseShort(node.getValue()), (Type)SmallintType.SMALLINT);
                }
                if (BigintType.BIGINT.equals((Object)type)) {
                    return Expressions.constant(Long.parseLong(node.getValue()), (Type)BigintType.BIGINT);
                }
            }
            catch (NumberFormatException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, String.format("Invalid formatted generic %s literal: %s", type, node), new Object[0]);
            }
            if (JsonType.JSON.equals((Object)type)) {
                return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), "json_parse", this.functionAndTypeResolver.lookupFunction("json_parse", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})), this.getType((Expression)node), new RowExpression[]{Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR)});
            }
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast("CAST", (Type)VarcharType.VARCHAR, this.getType((Expression)node)), this.getType((Expression)node), new RowExpression[]{Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR)});
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Context context) {
            long value = this.getType((Expression)node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : (this.sqlFunctionProperties.isLegacyTimestamp() ? DateTimeUtils.parseTimeWithoutTimeZone(this.sqlFunctionProperties.getTimeZoneKey(), node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(node.getValue()));
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Context context) {
            long value = this.sqlFunctionProperties.isLegacyTimestamp() ? DateTimeUtils.parseTimestampLiteral(this.sqlFunctionProperties.getTimeZoneKey(), node.getValue()) : DateTimeUtils.parseTimestampLiteral(node.getValue());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Context context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Context context) {
            RowExpression left = this.process((Node)node.getLeft(), context);
            RowExpression right = this.process((Node)node.getRight(), context);
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), node.getOperator().name(), this.functionResolution.comparisonFunction(node.getOperator(), left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Context context) {
            List arguments = (List)node.getArguments().stream().map(value -> this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).map(Type::getTypeSignature).map(TypeSignatureProvider::new).collect(ImmutableList.toImmutableList());
            return Expressions.call(node.getName().toString(), this.functionAndTypeResolver.resolveFunction(Optional.of(this.sessionFunctions), this.transactionId, FunctionAndTypeManager.qualifyObjectName(node.getName()), argumentTypes), this.getType((Expression)node), (List<RowExpression>)arguments);
        }

        protected RowExpression visitSymbolReference(SymbolReference node, Context context) {
            VariableReferenceExpression variable = new VariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)node), node.getName(), this.getType((Expression)node));
            Integer channel = this.layout.get(variable);
            if (channel != null) {
                return Expressions.field(variable.getSourceLocation(), channel, variable.getType());
            }
            return variable;
        }

        protected RowExpression visitLambdaExpression(LambdaExpression node, Context context) {
            RowExpression body = this.process((Node)node.getBody(), context);
            Type type = this.getType((Expression)node);
            List typeParameters = type.getTypeParameters();
            List argumentTypes = typeParameters.subList(0, typeParameters.size() - 1);
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            return new LambdaDefinitionExpression(ExpressionTreeUtils.getSourceLocation((Node)node), argumentTypes, argumentNames, body);
        }

        protected RowExpression visitBindExpression(BindExpression node, Context context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                RowExpression valueRowExpression = this.process((Node)value, context);
                valueTypesBuilder.add((Object)valueRowExpression.getType());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = this.process((Node)node.getFunction(), context);
            argumentsBuilder.add((Object)function);
            return Expressions.specialForm(SpecialFormExpression.Form.BIND, this.getType((Expression)node), (List<RowExpression>)argumentsBuilder.build());
        }

        protected RowExpression visitArithmeticBinary(ArithmeticBinaryExpression node, Context context) {
            RowExpression left = this.process((Node)node.getLeft(), context);
            RowExpression right = this.process((Node)node.getRight(), context);
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), node.getOperator().name(), this.functionResolution.arithmeticFunction(node.getOperator(), left.getType(), right.getType()), this.getType((Expression)node), left, right);
        }

        protected RowExpression visitArithmeticUnary(ArithmeticUnaryExpression node, Context context) {
            RowExpression expression = this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case PLUS: {
                    return expression;
                }
                case MINUS: {
                    return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), OperatorType.NEGATION.name(), this.functionAndTypeResolver.resolveOperator(OperatorType.NEGATION, TypeSignatureProvider.fromTypes((Type[])new Type[]{expression.getType()})), this.getType((Expression)node), expression);
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected RowExpression visitLogicalBinaryExpression(LogicalBinaryExpression node, Context context) {
            SpecialFormExpression.Form form;
            switch (node.getOperator()) {
                case AND: {
                    form = SpecialFormExpression.Form.AND;
                    break;
                }
                case OR: {
                    form = SpecialFormExpression.Form.OR;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown logical operator: " + node.getOperator());
                }
            }
            return Expressions.specialForm(ExpressionTreeUtils.getSourceLocation((Node)node), form, (Type)BooleanType.BOOLEAN, this.process((Node)node.getLeft(), context), this.process((Node)node.getRight(), context));
        }

        protected RowExpression visitCast(Cast node, Context context) {
            RowExpression value = this.process((Node)node.getExpression(), context);
            if (node.isSafe()) {
                return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.TRY_CAST.name(), this.functionAndTypeResolver.lookupCast("TRY_CAST", value.getType(), this.getType((Expression)node)), this.getType((Expression)node), value);
            }
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast("CAST", value.getType(), this.getType((Expression)node)), this.getType((Expression)node), value);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Context context) {
            List arguments = (List)node.getOperands().stream().map(value -> this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            return Expressions.specialForm(SpecialFormExpression.Form.COALESCE, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Context context) {
            return this.buildSwitch(this.process((Node)node.getOperand(), context), node.getWhenClauses(), node.getDefaultValue(), this.getType((Expression)node), context);
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Context context) {
            return this.buildSwitch((RowExpression)new ConstantExpression(ExpressionTreeUtils.getSourceLocation((Node)node), (Object)true, (Type)BooleanType.BOOLEAN), node.getWhenClauses(), node.getDefaultValue(), this.getType((Expression)node), context);
        }

        private RowExpression buildSwitch(RowExpression operand, List<WhenClause> whenClauses, Optional<Expression> defaultValue, Type returnType, Context context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)operand);
            for (WhenClause clause : whenClauses) {
                arguments.add((Object)Expressions.specialForm(ExpressionTreeUtils.getSourceLocation((Node)clause), SpecialFormExpression.Form.WHEN, this.getType(clause.getResult()), this.process((Node)clause.getOperand(), context), this.process((Node)clause.getResult(), context)));
            }
            arguments.add((Object)defaultValue.map(value -> this.process((Node)value, context)).orElse((RowExpression)Expressions.constantNull(operand.getSourceLocation(), returnType)));
            return Expressions.specialForm(SpecialFormExpression.Form.SWITCH, returnType, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitDereferenceExpression(DereferenceExpression node, Context context) {
            OptionalInt rowIndex;
            Type returnType = this.getType((Expression)node);
            Type baseType = this.getType(node.getBase());
            if (baseType == null) {
                return new UnresolvedSymbolExpression(ExpressionTreeUtils.getSourceLocation((Node)node), returnType, DereferenceExpression.getQualifiedName((DereferenceExpression)node).getParts());
            }
            if (TypeUtils.isEnumType((Type)baseType) && TypeUtils.isEnumType((Type)returnType)) {
                return Expressions.constant(ExpressionTreeUtils.resolveEnumLiteral(node, baseType), returnType);
            }
            if (baseType instanceof TypeWithName) {
                baseType = ((TypeWithName)baseType).getType();
            }
            if (baseType instanceof DistinctType) {
                baseType = ((DistinctType)baseType).getBaseType();
            }
            RowType rowType = (RowType)baseType;
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            if (this.sqlFunctionProperties.isLegacyRowFieldOrdinalAccessEnabled() && index < 0 && (rowIndex = LegacyRowFieldOrdinalAccessUtil.parseAnonymousRowFieldOrdinalAccess(fieldName, fields)).isPresent()) {
                index = rowIndex.getAsInt();
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            return Expressions.specialForm(ExpressionTreeUtils.getSourceLocation((Node)node.getBase()), SpecialFormExpression.Form.DEREFERENCE, returnType, new RowExpression[]{this.process((Node)node.getBase(), context), Expressions.constant(index, (Type)IntegerType.INTEGER)});
        }

        protected RowExpression visitIfExpression(IfExpression node, Context context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)this.process((Node)node.getCondition(), context)).add((Object)this.process((Node)node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                arguments.add((Object)this.process((Node)node.getFalseValue().get(), context));
            } else {
                arguments.add((Object)Expressions.constantNull(ExpressionTreeUtils.getSourceLocation((Node)node), this.getType((Expression)node)));
            }
            return Expressions.specialForm(SpecialFormExpression.Form.IF, this.getType((Expression)node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitTryExpression(TryExpression node, Context context) {
            RowExpression body = this.process((Node)node.getInnerExpression(), context);
            return Expressions.call(this.functionAndTypeResolver, "$internal$try", this.getType((Expression)node), new RowExpression[]{new LambdaDefinitionExpression(ExpressionTreeUtils.getSourceLocation((Node)node), (List)ImmutableList.of(), (List)ImmutableList.of(), body)});
        }

        private RowExpression buildEquals(RowExpression lhs, RowExpression rhs) {
            return Expressions.call(OperatorType.EQUAL.getOperator(), this.functionResolution.comparisonFunction(ComparisonExpression.Operator.EQUAL, lhs.getType(), rhs.getType()), (Type)BooleanType.BOOLEAN, lhs, rhs);
        }

        protected RowExpression visitExists(ExistsPredicate existsPredicate, Context context) {
            RowExpression subquery = this.process((Node)existsPredicate.getSubquery(), context);
            return new ExistsExpression(subquery.getSourceLocation(), subquery);
        }

        protected RowExpression visitQuantifiedComparisonExpression(QuantifiedComparisonExpression expression, Context context) {
            return Expressions.quantifiedComparison(OperatorType.valueOf((String)expression.getOperator().name()), QuantifiedComparisonExpression.Quantifier.valueOf((String)expression.getQuantifier().name()), this.process((Node)expression.getValue(), context), this.process((Node)expression.getSubquery(), context));
        }

        protected RowExpression visitInPredicate(InPredicate node, Context context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            RowExpression value = this.process((Node)node.getValue(), context);
            if (!(node.getValueList() instanceof InListExpression)) {
                RowExpression subquery = this.process((Node)node.getValueList(), context);
                Preconditions.checkArgument((boolean)(value instanceof VariableReferenceExpression), (String)"Unexpected expression: %s", (Object)value);
                Preconditions.checkArgument((boolean)(subquery instanceof VariableReferenceExpression), (String)"Unexpected expression: %s", (Object)subquery);
                return Expressions.inSubquery((VariableReferenceExpression)value, (VariableReferenceExpression)subquery);
            }
            InListExpression values = (InListExpression)node.getValueList();
            if (values.getValues().size() == 1) {
                return this.buildEquals(value, this.process((Node)values.getValues().get(0), context));
            }
            arguments.add((Object)value);
            for (Expression inValue : values.getValues()) {
                arguments.add((Object)this.process((Node)inValue, context));
            }
            return Expressions.specialForm(SpecialFormExpression.Form.IN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Context context) {
            RowExpression expression = this.process((Node)node.getValue(), context);
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), "not", this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, new RowExpression[]{Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression))});
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Context context) {
            RowExpression expression = this.process((Node)node.getValue(), context);
            return Expressions.specialForm(ExpressionTreeUtils.getSourceLocation((Node)node), SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Context context) {
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), "not", this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, this.process((Node)node.getValue(), context));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Context context) {
            RowExpression first = this.process((Node)node.getFirst(), context);
            RowExpression second = this.process((Node)node.getSecond(), context);
            Type returnType = this.getType((Expression)node);
            if (!this.functionAndTypeManager.nullIfSpecialFormEnabled()) {
                if (first.getType().equals(UnknownType.UNKNOWN)) {
                    return Expressions.constantNull((Type)UnknownType.UNKNOWN);
                }
                RowExpression firstArgWithoutCast = first;
                if (!second.getType().equals(first.getType())) {
                    Optional commonType = this.functionAndTypeResolver.getCommonSuperType(first.getType(), second.getType());
                    if (!commonType.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", new Object[]{first.getType(), second.getType()});
                    }
                    if (!first.getType().equals(commonType.get())) {
                        first = Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast(CastType.CAST.name(), first.getType(), (Type)commonType.get()), (Type)commonType.get(), first);
                    }
                    if (!second.getType().equals(commonType.get())) {
                        second = Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast(CastType.CAST.name(), second.getType(), (Type)commonType.get()), (Type)commonType.get(), second);
                    }
                }
                FunctionHandle equalsFunctionHandle = this.functionAndTypeResolver.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{first.getType(), second.getType()}));
                CallExpression equal = Expressions.call(OperatorType.EQUAL.name(), equalsFunctionHandle, (Type)BooleanType.BOOLEAN, first, second);
                return Expressions.specialForm(SpecialFormExpression.Form.IF, returnType, new RowExpression[]{equal, Expressions.constantNull(returnType), firstArgWithoutCast});
            }
            return Expressions.specialForm(ExpressionTreeUtils.getSourceLocation((Node)node), SpecialFormExpression.Form.NULL_IF, returnType, first, second);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Context context) {
            RowExpression value = this.process((Node)node.getValue(), context);
            RowExpression min = this.process((Node)node.getMin(), context);
            RowExpression max = this.process((Node)node.getMax(), context);
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), OperatorType.BETWEEN.name(), this.functionAndTypeResolver.resolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes((Type[])new Type[]{value.getType(), min.getType(), max.getType()})), (Type)BooleanType.BOOLEAN, value, min, max);
        }

        protected RowExpression visitLikePredicate(LikePredicate node, Context context) {
            RowExpression value = this.process((Node)node.getValue(), context);
            RowExpression pattern = this.process((Node)node.getPattern(), context);
            if (node.getEscape().isPresent()) {
                RowExpression escape = this.process((Node)node.getEscape().get(), context);
                return this.likeFunctionCall(value, (RowExpression)Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), "LIKE_PATTERN", this.functionResolution.likePatternFunction(), (Type)LikePatternType.LIKE_PATTERN, pattern, escape));
            }
            RowExpression prefixOrSuffixMatch = this.generateLikePrefixOrSuffixMatch(value, pattern);
            if (prefixOrSuffixMatch != null) {
                return prefixOrSuffixMatch;
            }
            return this.likeFunctionCall(value, (RowExpression)Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast("CAST", (Type)VarcharType.VARCHAR, (Type)LikePatternType.LIKE_PATTERN), (Type)LikePatternType.LIKE_PATTERN, pattern));
        }

        private RowExpression generateLikePrefixOrSuffixMatch(RowExpression value, RowExpression pattern) {
            Object constObject;
            if (value.getType() instanceof VarcharType && pattern instanceof ConstantExpression && (constObject = ((ConstantExpression)pattern).getValue()) instanceof Slice) {
                Slice slice = (Slice)constObject;
                String patternString = slice.toStringUtf8();
                int matchCharacterLength = patternString.length();
                int matchBytesLength = slice.length();
                if (matchCharacterLength > 1 && !patternString.contains("_")) {
                    if (LIKE_PREFIX_MATCH_PATTERN.matcher(patternString).matches()) {
                        return this.buildEquals((RowExpression)Expressions.call(this.functionAndTypeManager, "SUBSTR", (Type)VarcharType.VARCHAR, new RowExpression[]{value, Expressions.constant(1L, (Type)BigintType.BIGINT), Expressions.constant((long)matchCharacterLength - 1L, (Type)BigintType.BIGINT)}), (RowExpression)Expressions.constant(slice.slice(0, matchBytesLength - 1), (Type)VarcharType.VARCHAR));
                    }
                    if (LIKE_SUFFIX_MATCH_PATTERN.matcher(patternString).matches()) {
                        return this.buildEquals((RowExpression)Expressions.call(this.functionAndTypeManager, "SUBSTR", (Type)VarcharType.VARCHAR, new RowExpression[]{value, Expressions.constant(-((long)(matchCharacterLength - 1)), (Type)BigintType.BIGINT)}), (RowExpression)Expressions.constant(slice.slice(1, matchBytesLength - 1), (Type)VarcharType.VARCHAR));
                    }
                    if (LIKE_SIMPLE_EXISTS_PATTERN.matcher(patternString).matches()) {
                        return this.buildEquals((RowExpression)Expressions.call(this.functionAndTypeManager, "CARDINALITY", (Type)BigintType.BIGINT, new RowExpression[]{Expressions.call(this.functionAndTypeManager, "SPLIT", (Type)new ArrayType((Type)VarcharType.VARCHAR), new RowExpression[]{value, Expressions.constant(slice.slice(1, matchBytesLength - 2), (Type)VarcharType.VARCHAR), Expressions.constant(2L, (Type)BigintType.BIGINT)})}), (RowExpression)Expressions.constant(2L, (Type)BigintType.BIGINT));
                    }
                }
            }
            return null;
        }

        private RowExpression likeFunctionCall(RowExpression value, RowExpression pattern) {
            if (value.getType() instanceof VarcharType) {
                return Expressions.call((Optional<SourceLocation>)value.getSourceLocation(), "LIKE", this.functionResolution.likeVarcharFunction(), (Type)BooleanType.BOOLEAN, value, pattern);
            }
            Preconditions.checkState((boolean)(value.getType() instanceof CharType), (Object)"LIKE value type is neither VARCHAR or CHAR");
            return Expressions.call((Optional<SourceLocation>)value.getSourceLocation(), "LIKE", this.functionResolution.likeCharFunction(value.getType()), (Type)BooleanType.BOOLEAN, value, pattern);
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Context context) {
            RowExpression base = this.process((Node)node.getBase(), context);
            RowExpression index = this.process((Node)node.getIndex(), context);
            if (base.getType() instanceof RowType) {
                Preconditions.checkState((boolean)(index instanceof ConstantExpression), (Object)"Subscript expression on ROW requires a ConstantExpression");
                ConstantExpression position = (ConstantExpression)index;
                Preconditions.checkState((boolean)(position.getValue() instanceof Long), (Object)"ConstantExpression should contain a valid integer index into the row");
                Long offset = (Long)position.getValue();
                Preconditions.checkState((offset >= 1L && offset <= (long)base.getType().getTypeParameters().size() ? 1 : 0) != 0, (String)"Subscript index out of bounds %s: should be >= 1 and <= %s", (Object)offset, (int)base.getType().getTypeParameters().size());
                return Expressions.specialForm(ExpressionTreeUtils.getSourceLocation((Node)node), SpecialFormExpression.Form.DEREFERENCE, this.getType((Expression)node), new RowExpression[]{base, Expressions.constant(offset - 1L, (Type)IntegerType.INTEGER)});
            }
            return Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), OperatorType.SUBSCRIPT.name(), this.functionAndTypeResolver.resolveOperator(OperatorType.SUBSCRIPT, TypeSignatureProvider.fromTypes((Type[])new Type[]{base.getType(), index.getType()})), this.getType((Expression)node), base, index);
        }

        protected RowExpression visitArrayConstructor(ArrayConstructor node, Context context) {
            List arguments = (List)node.getValues().stream().map(value -> this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call("ARRAY", this.functionResolution.arrayConstructor(argumentTypes), this.getType((Expression)node), (List<RowExpression>)arguments);
        }

        protected RowExpression visitRow(Row node, Context context) {
            List arguments = (List)node.getItems().stream().map(value -> this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = this.getType((Expression)node);
            return Expressions.specialForm(SpecialFormExpression.Form.ROW_CONSTRUCTOR, returnType, arguments);
        }

        protected RowExpression visitCurrentTime(CurrentTime node, Context context) {
            if (node.getPrecision() != null) {
                throw new UnsupportedOperationException("not yet implemented: non-default precision");
            }
            switch (node.getFunction()) {
                case DATE: {
                    return Expressions.call(this.functionAndTypeResolver, "current_date", this.getType((Expression)node), new RowExpression[0]);
                }
                case TIME: {
                    return Expressions.call(this.functionAndTypeResolver, "current_time", this.getType((Expression)node), new RowExpression[0]);
                }
                case LOCALTIME: {
                    return Expressions.call(this.functionAndTypeResolver, "localtime", this.getType((Expression)node), new RowExpression[0]);
                }
                case TIMESTAMP: {
                    return Expressions.call(this.functionAndTypeResolver, "current_timestamp", this.getType((Expression)node), new RowExpression[0]);
                }
                case LOCALTIMESTAMP: {
                    return Expressions.call(this.functionAndTypeResolver, "localtimestamp", this.getType((Expression)node), new RowExpression[0]);
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getFunction());
        }

        protected RowExpression visitExtract(Extract node, Context context) {
            RowExpression value = this.process((Node)node.getExpression(), context);
            switch (node.getField()) {
                case YEAR: {
                    return Expressions.call(this.functionAndTypeResolver, "year", this.getType((Expression)node), value);
                }
                case QUARTER: {
                    return Expressions.call(this.functionAndTypeResolver, "quarter", this.getType((Expression)node), value);
                }
                case MONTH: {
                    return Expressions.call(this.functionAndTypeResolver, "month", this.getType((Expression)node), value);
                }
                case WEEK: {
                    return Expressions.call(this.functionAndTypeResolver, "week", this.getType((Expression)node), value);
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return Expressions.call(this.functionAndTypeResolver, "day", this.getType((Expression)node), value);
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return Expressions.call(this.functionAndTypeResolver, "day_of_week", this.getType((Expression)node), value);
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return Expressions.call(this.functionAndTypeResolver, "day_of_year", this.getType((Expression)node), value);
                }
                case YEAR_OF_WEEK: 
                case YOW: {
                    return Expressions.call(this.functionAndTypeResolver, "year_of_week", this.getType((Expression)node), value);
                }
                case HOUR: {
                    return Expressions.call(this.functionAndTypeResolver, "hour", this.getType((Expression)node), value);
                }
                case MINUTE: {
                    return Expressions.call(this.functionAndTypeResolver, "minute", this.getType((Expression)node), value);
                }
                case SECOND: {
                    return Expressions.call(this.functionAndTypeResolver, "second", this.getType((Expression)node), value);
                }
                case TIMEZONE_MINUTE: {
                    return Expressions.call(this.functionAndTypeResolver, "timezone_minute", this.getType((Expression)node), value);
                }
                case TIMEZONE_HOUR: {
                    return Expressions.call(this.functionAndTypeResolver, "timezone_hour", this.getType((Expression)node), value);
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }

        protected RowExpression visitAtTimeZone(AtTimeZone node, Context context) {
            RowExpression value = this.process((Node)node.getValue(), context);
            RowExpression timeZone = this.process((Node)node.getTimeZone(), context);
            Type valueType = value.getType();
            if (valueType.equals(TimeType.TIME)) {
                value = Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast("CAST", valueType, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE), (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, value);
            } else if (valueType.equals(TimestampType.TIMESTAMP)) {
                value = Expressions.call(ExpressionTreeUtils.getSourceLocation((Node)node), CastType.CAST.name(), this.functionAndTypeResolver.lookupCast("CAST", valueType, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE), (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, value);
            }
            return Expressions.call(this.functionAndTypeResolver, "at_timezone", this.getType((Expression)node), value, timeZone);
        }

        protected RowExpression visitCurrentUser(CurrentUser node, Context context) {
            return Expressions.call(this.functionAndTypeResolver, "$current_user", this.getType((Expression)node), new RowExpression[0]);
        }
    }

    public static class Context {
        private final Map<Expression, RowExpression> rowExpressionMap = new IdentityHashMap<Expression, RowExpression>();
        private final Map<RowExpression, Expression> expressionMap = new IdentityHashMap<RowExpression, Expression>();

        public Map<Expression, RowExpression> getRowExpressionMap() {
            return this.rowExpressionMap;
        }

        public Map<RowExpression, Expression> getExpressionMap() {
            return this.expressionMap;
        }

        public void put(Expression expression, RowExpression rowExpression) {
            this.rowExpressionMap.put(expression, rowExpression);
            this.expressionMap.put(rowExpression, expression);
        }
    }
}

