/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InSubqueryExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.QuantifiedComparisonExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class Expressions {
    private static final List<String> COMPARISON_FUNCTIONS = (List)Arrays.stream(OperatorType.values()).filter(OperatorType::isComparisonOperator).map(operator -> operator.getFunctionName().toString()).collect(ImmutableList.toImmutableList());

    private Expressions() {
    }

    private static Optional<SourceLocation> getFirstSourceLocation(List<RowExpression> expressions) {
        return expressions.stream().filter(x -> x.getSourceLocation().isPresent()).map(x -> x.getSourceLocation()).findFirst().orElse(Optional.empty());
    }

    public static ConstantExpression constant(Object value, Type type) {
        return Expressions.constant(Optional.empty(), value, type);
    }

    public static ConstantExpression constant(Optional<SourceLocation> sourceLocation, Object value, Type type) {
        return new ConstantExpression(sourceLocation, value, type);
    }

    public static ConstantExpression constantNull(Type type) {
        return Expressions.constantNull(Optional.empty(), type);
    }

    public static ConstantExpression constantNull(Optional<SourceLocation> sourceLocation, Type type) {
        return new ConstantExpression(sourceLocation, null, type);
    }

    public static boolean isNull(RowExpression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNull();
    }

    public static boolean isComparison(CallExpression callExpression) {
        return COMPARISON_FUNCTIONS.contains(callExpression.getFunctionHandle().getName());
    }

    public static SpecialFormExpression coalesceNullToFalse(RowExpression rowExpression) {
        return Expressions.coalesce(rowExpression, (RowExpression)Expressions.constant(false, (Type)BooleanType.BOOLEAN));
    }

    public static SpecialFormExpression coalesce(RowExpression rowExpression, RowExpression coalesced) {
        Preconditions.checkState((boolean)rowExpression.getType().equals(coalesced.getType()));
        return new SpecialFormExpression(rowExpression.getSourceLocation(), SpecialFormExpression.Form.COALESCE, coalesced.getType(), new RowExpression[]{rowExpression, coalesced});
    }

    public static CallExpression not(FunctionAndTypeManager functionAndTypeManager, RowExpression rowExpression) {
        return Expressions.call(functionAndTypeManager, "not", (Type)BooleanType.BOOLEAN, rowExpression);
    }

    public static CallExpression call(String displayName, FunctionHandle functionHandle, Type returnType, RowExpression ... arguments) {
        return Expressions.call(displayName, functionHandle, returnType, Arrays.asList(arguments));
    }

    public static CallExpression call(Optional<SourceLocation> sourceLocation, String displayName, FunctionHandle functionHandle, Type returnType, RowExpression ... arguments) {
        return new CallExpression(displayName, functionHandle, returnType, Arrays.asList(arguments));
    }

    public static CallExpression call(String displayName, FunctionHandle functionHandle, Type returnType, List<RowExpression> arguments) {
        return new CallExpression(Expressions.getFirstSourceLocation(arguments), displayName, functionHandle, returnType, arguments);
    }

    public static CallExpression call(Optional<SourceLocation> sourceLocation, String displayName, FunctionHandle functionHandle, Type returnType, List<RowExpression> arguments) {
        return new CallExpression(sourceLocation, displayName, functionHandle, returnType, arguments);
    }

    public static CallExpression call(FunctionAndTypeManager functionAndTypeManager, String name, Type returnType, RowExpression ... arguments) {
        return Expressions.call(functionAndTypeManager, name, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static CallExpression call(FunctionAndTypeManager functionAndTypeManager, String name, Type returnType, List<RowExpression> arguments) {
        FunctionHandle functionHandle = functionAndTypeManager.lookupFunction(name, TypeSignatureProvider.fromTypes((List)((List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList()))));
        return Expressions.call(name, functionHandle, returnType, arguments);
    }

    public static CallExpression call(FunctionAndTypeResolver functionAndTypeResolver, String name, Type returnType, RowExpression ... arguments) {
        FunctionHandle functionHandle = functionAndTypeResolver.lookupFunction(name, TypeSignatureProvider.fromTypes((List)((List)Arrays.stream(arguments).map(RowExpression::getType).collect(ImmutableList.toImmutableList()))));
        return Expressions.call(name, functionHandle, returnType, arguments);
    }

    public static CallExpression callOperator(FunctionAndTypeResolver functionAndTypeResolver, OperatorType operatorType, Type returnType, RowExpression ... arguments) {
        FunctionHandle functionHandle = functionAndTypeResolver.resolveOperator(operatorType, TypeSignatureProvider.fromTypes((List)((List)Arrays.stream(arguments).map(RowExpression::getType).collect(ImmutableList.toImmutableList()))));
        return Expressions.call(operatorType.name(), functionHandle, returnType, arguments);
    }

    public static RowExpression castToBigInt(FunctionAndTypeManager functionAndTypeManager, RowExpression rowExpression) {
        if (rowExpression.getType().equals(BigintType.BIGINT)) {
            return rowExpression;
        }
        return Expressions.call("CAST", functionAndTypeManager.lookupCast(CastType.CAST, rowExpression.getType(), (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, rowExpression);
    }

    public static RowExpression castToInteger(FunctionAndTypeManager functionAndTypeManager, RowExpression rowExpression) {
        if (rowExpression.getType().equals(IntegerType.INTEGER)) {
            return rowExpression;
        }
        return Expressions.call("CAST", functionAndTypeManager.lookupCast(CastType.CAST, rowExpression.getType(), (Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER, rowExpression);
    }

    public static RowExpression tryCast(FunctionAndTypeManager functionAndTypeManager, RowExpression rowExpression, Type castToType) {
        return Expressions.call("TRY_CAST", functionAndTypeManager.lookupCast(CastType.TRY_CAST, rowExpression.getType(), castToType), castToType, rowExpression);
    }

    public static RowExpression searchedCaseExpression(List<RowExpression> whenClauses, Optional<RowExpression> defaultValue) {
        return Expressions.buildSwitch((RowExpression)new ConstantExpression((Object)true, (Type)BooleanType.BOOLEAN), whenClauses, defaultValue, (Type)BooleanType.BOOLEAN);
    }

    public static RowExpression buildSwitch(RowExpression operand, List<RowExpression> whenClauses, Optional<RowExpression> defaultValue, Type returnType) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add((Object)operand);
        arguments.addAll(whenClauses);
        arguments.add((Object)defaultValue.orElse((RowExpression)Expressions.constantNull(operand.getSourceLocation(), returnType)));
        return Expressions.specialForm(SpecialFormExpression.Form.SWITCH, returnType, (List<RowExpression>)arguments.build());
    }

    public static RowExpression comparisonExpression(StandardFunctionResolution functionResolution, OperatorType operatorType, RowExpression left, RowExpression right) {
        return Expressions.call(operatorType.name(), functionResolution.comparisonFunction(operatorType, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
    }

    public static InputReferenceExpression field(Optional<SourceLocation> sourceLocation, int field, Type type) {
        return new InputReferenceExpression(sourceLocation, field, type);
    }

    public static InputReferenceExpression field(int field, Type type) {
        return new InputReferenceExpression(Optional.empty(), field, type);
    }

    public static SpecialFormExpression specialForm(SpecialFormExpression.Form form, Type returnType, RowExpression ... arguments) {
        return Expressions.specialForm(form, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static SpecialFormExpression specialForm(Optional<SourceLocation> sourceLocation, SpecialFormExpression.Form form, Type returnType, RowExpression ... arguments) {
        return Expressions.specialForm(sourceLocation, form, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static SpecialFormExpression specialForm(SpecialFormExpression.Form form, Type returnType, List<RowExpression> arguments) {
        return Expressions.specialForm(Expressions.getFirstSourceLocation(arguments), form, returnType, arguments);
    }

    public static SpecialFormExpression specialForm(Optional<SourceLocation> sourceLocation, SpecialFormExpression.Form form, Type returnType, List<RowExpression> arguments) {
        return new SpecialFormExpression(sourceLocation, form, returnType, arguments);
    }

    public static InSubqueryExpression inSubquery(VariableReferenceExpression value, VariableReferenceExpression subquery) {
        return new InSubqueryExpression(Expressions.getFirstSourceLocation(Arrays.asList(value, subquery)), value, subquery);
    }

    public static QuantifiedComparisonExpression quantifiedComparison(OperatorType operator, QuantifiedComparisonExpression.Quantifier quantifier, RowExpression value, RowExpression subquery) {
        return new QuantifiedComparisonExpression(Expressions.getFirstSourceLocation(Arrays.asList(value, subquery)), operator, quantifier, value, subquery);
    }

    public static Set<RowExpression> uniqueSubExpressions(RowExpression expression) {
        return ImmutableSet.copyOf(Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression)));
    }

    public static List<RowExpression> subExpressions(RowExpression expression) {
        return Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    public static List<RowExpression> subExpressions(Iterable<RowExpression> expressions) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : expressions) {
            expression.accept((RowExpressionVisitor)new RowExpressionVisitor<Void, Void>(){

                public Void visitCall(CallExpression call, Void context) {
                    builder.add((Object)call);
                    for (RowExpression argument : call.getArguments()) {
                        argument.accept((RowExpressionVisitor)this, (Object)context);
                    }
                    return null;
                }

                public Void visitInputReference(InputReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                public Void visitConstant(ConstantExpression literal, Void context) {
                    builder.add((Object)literal);
                    return null;
                }

                public Void visitLambda(LambdaDefinitionExpression lambda, Void context) {
                    builder.add((Object)lambda);
                    lambda.getBody().accept((RowExpressionVisitor)this, (Object)context);
                    return null;
                }

                public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                public Void visitSpecialForm(SpecialFormExpression specialForm, Void context) {
                    builder.add((Object)specialForm);
                    for (RowExpression argument : specialForm.getArguments()) {
                        argument.accept((RowExpressionVisitor)this, (Object)context);
                    }
                    return null;
                }
            }, null);
        }
        return builder.build();
    }

    public static VariableReferenceExpression variable(String name, Type type) {
        return Expressions.variable(Optional.empty(), name, type);
    }

    public static VariableReferenceExpression variable(Optional<SourceLocation> sourceLocation, String name, Type type) {
        return new VariableReferenceExpression(sourceLocation, name, type);
    }
}

