/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations.joins;

import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.ProjectNodeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JoinGraph {
    private final Optional<Map<VariableReferenceExpression, RowExpression>> assignments;
    private final List<RowExpression> filters;
    private final List<PlanNode> nodes;
    private final Multimap<PlanNodeId, Edge> edges;
    private final PlanNodeId rootId;

    public static List<JoinGraph> buildFrom(PlanNode plan) {
        return JoinGraph.buildFrom(plan, Lookup.noLookup());
    }

    public static JoinGraph buildShallowFrom(PlanNode plan, Lookup lookup) {
        JoinGraph graph = (JoinGraph)plan.accept((PlanVisitor)new Builder(true, lookup), (Object)new Context());
        return graph;
    }

    private static List<JoinGraph> buildFrom(PlanNode plan, Lookup lookup) {
        Context context = new Context();
        JoinGraph graph = (JoinGraph)plan.accept((PlanVisitor)new Builder(false, lookup), (Object)context);
        if (graph.size() > 1) {
            context.addSubGraph(graph);
        }
        return context.getGraphs();
    }

    public JoinGraph(PlanNode node) {
        this((List<PlanNode>)ImmutableList.of((Object)node), (Multimap<PlanNodeId, Edge>)ImmutableMultimap.of(), node.getId(), (List<RowExpression>)ImmutableList.of(), Optional.empty());
    }

    public JoinGraph(List<PlanNode> nodes, Multimap<PlanNodeId, Edge> edges, PlanNodeId rootId, List<RowExpression> filters, Optional<Map<VariableReferenceExpression, RowExpression>> assignments) {
        this.nodes = nodes;
        this.edges = edges;
        this.rootId = rootId;
        this.filters = filters;
        this.assignments = assignments;
    }

    public JoinGraph withAssignments(Map<VariableReferenceExpression, RowExpression> assignments) {
        return new JoinGraph(this.nodes, this.edges, this.rootId, this.filters, Optional.of(assignments));
    }

    public Optional<Map<VariableReferenceExpression, RowExpression>> getAssignments() {
        return this.assignments;
    }

    public JoinGraph withFilter(RowExpression expression) {
        ImmutableList.Builder filters = ImmutableList.builder();
        filters.addAll(this.filters);
        filters.add((Object)expression);
        return new JoinGraph(this.nodes, this.edges, this.rootId, (List<RowExpression>)filters.build(), this.assignments);
    }

    public List<RowExpression> getFilters() {
        return this.filters;
    }

    public PlanNodeId getRootId() {
        return this.rootId;
    }

    public JoinGraph withRootId(PlanNodeId rootId) {
        return new JoinGraph(this.nodes, this.edges, rootId, this.filters, this.assignments);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public PlanNode getNode(int index) {
        return this.nodes.get(index);
    }

    public List<PlanNode> getNodes() {
        return this.nodes;
    }

    public Collection<Edge> getEdges(PlanNode node) {
        return ImmutableList.copyOf((Collection)this.edges.get((Object)node.getId()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (PlanNode nodeFrom : this.nodes) {
            builder.append(nodeFrom.getId()).append(" = ").append(nodeFrom.toString()).append("\n");
        }
        for (PlanNode nodeFrom : this.nodes) {
            builder.append(nodeFrom.getId()).append(":");
            for (Edge nodeTo : this.edges.get((Object)nodeFrom.getId())) {
                builder.append(" ").append(nodeTo.getTargetNode().getId());
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private JoinGraph joinWith(JoinGraph other, List<EquiJoinClause> joinClauses, Context context, PlanNodeId newRoot) {
        for (PlanNode node : other.nodes) {
            Preconditions.checkState((!this.edges.containsKey((Object)node.getId()) ? 1 : 0) != 0, (Object)String.format("Node [%s] appeared in two JoinGraphs", node));
        }
        ImmutableList nodes = ImmutableList.builder().addAll(this.nodes).addAll(other.nodes).build();
        ImmutableMultimap.Builder edges = ImmutableMultimap.builder().putAll(this.edges).putAll(other.edges);
        ImmutableList joinedFilters = ImmutableList.builder().addAll(this.filters).addAll(other.filters).build();
        for (EquiJoinClause edge : joinClauses) {
            VariableReferenceExpression leftVariable = edge.getLeft();
            VariableReferenceExpression rightVariable = edge.getRight();
            Preconditions.checkState((boolean)context.containsVariable(leftVariable));
            Preconditions.checkState((boolean)context.containsVariable(rightVariable));
            PlanNode left = context.getVariableSource(leftVariable);
            PlanNode right = context.getVariableSource(rightVariable);
            edges.put((Object)left.getId(), (Object)new Edge(right, leftVariable, rightVariable));
            edges.put((Object)right.getId(), (Object)new Edge(left, rightVariable, leftVariable));
        }
        return new JoinGraph((List<PlanNode>)nodes, (Multimap<PlanNodeId, Edge>)edges.build(), newRoot, (List<RowExpression>)joinedFilters, Optional.empty());
    }

    private static class Context {
        private final Map<VariableReferenceExpression, PlanNode> variableSources = new HashMap<VariableReferenceExpression, PlanNode>();
        private final List<JoinGraph> joinGraphs = new ArrayList<JoinGraph>();

        private Context() {
        }

        public void setVariableSource(VariableReferenceExpression variable, PlanNode node) {
            this.variableSources.put(variable, node);
        }

        public void addSubGraph(JoinGraph graph) {
            this.joinGraphs.add(graph);
        }

        public boolean containsVariable(VariableReferenceExpression variable) {
            return this.variableSources.containsKey(variable);
        }

        public PlanNode getVariableSource(VariableReferenceExpression variable) {
            Preconditions.checkState((boolean)this.containsVariable(variable));
            return this.variableSources.get(variable);
        }

        public List<JoinGraph> getGraphs() {
            return this.joinGraphs;
        }
    }

    public static class Edge {
        private final PlanNode targetNode;
        private final VariableReferenceExpression sourceVariable;
        private final VariableReferenceExpression targetVariable;

        public Edge(PlanNode targetNode, VariableReferenceExpression sourceVariable, VariableReferenceExpression targetVariable) {
            this.targetNode = Objects.requireNonNull(targetNode, "targetNode is null");
            this.sourceVariable = Objects.requireNonNull(sourceVariable, "sourceVariable is null");
            this.targetVariable = Objects.requireNonNull(targetVariable, "targetVariable is null");
        }

        public PlanNode getTargetNode() {
            return this.targetNode;
        }

        public VariableReferenceExpression getSourceVariable() {
            return this.sourceVariable;
        }

        public VariableReferenceExpression getTargetVariable() {
            return this.targetVariable;
        }
    }

    private static class Builder
    extends InternalPlanVisitor<JoinGraph, Context> {
        private final boolean shallow;
        private final Lookup lookup;

        private Builder(boolean shallow, Lookup lookup) {
            this.shallow = shallow;
            this.lookup = Objects.requireNonNull(lookup, "lookup cannot be null");
        }

        public JoinGraph visitPlan(PlanNode node, Context context) {
            if (!this.shallow) {
                for (PlanNode child : node.getSources()) {
                    JoinGraph graph = (JoinGraph)child.accept((PlanVisitor)this, (Object)context);
                    if (graph.size() < 2) continue;
                    context.addSubGraph(graph.withRootId(child.getId()));
                }
            }
            for (VariableReferenceExpression variable : node.getOutputVariables()) {
                context.setVariableSource(variable, node);
            }
            return new JoinGraph(node);
        }

        public JoinGraph visitFilter(FilterNode node, Context context) {
            JoinGraph graph = (JoinGraph)node.getSource().accept((PlanVisitor)this, (Object)context);
            return graph.withFilter(node.getPredicate());
        }

        @Override
        public JoinGraph visitJoin(JoinNode node, Context context) {
            if (node.getType() != JoinType.INNER) {
                return this.visitPlan((PlanNode)node, context);
            }
            JoinGraph left = (JoinGraph)node.getLeft().accept((PlanVisitor)this, (Object)context);
            JoinGraph right = (JoinGraph)node.getRight().accept((PlanVisitor)this, (Object)context);
            JoinGraph graph = left.joinWith(right, node.getCriteria(), context, node.getId());
            if (node.getFilter().isPresent()) {
                return graph.withFilter(node.getFilter().get());
            }
            return graph;
        }

        public JoinGraph visitProject(ProjectNode node, Context context) {
            if (ProjectNodeUtils.isIdentity(node)) {
                JoinGraph graph = (JoinGraph)node.getSource().accept((PlanVisitor)this, (Object)context);
                return graph.withAssignments(node.getAssignments().getMap());
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public JoinGraph visitGroupReference(GroupReference node, Context context) {
            PlanNode dereferenced = this.lookup.resolve(node);
            JoinGraph graph = (JoinGraph)dereferenced.accept((PlanVisitor)this, (Object)context);
            if (this.isTrivialGraph(graph)) {
                return this.replacementGraph(dereferenced, node, context);
            }
            return graph;
        }

        private boolean isTrivialGraph(JoinGraph graph) {
            return graph.nodes.size() < 2 && graph.edges.isEmpty() && graph.filters.isEmpty() && !graph.assignments.isPresent();
        }

        private JoinGraph replacementGraph(PlanNode oldNode, PlanNode newNode, Context context) {
            List variables = (List)context.variableSources.entrySet().stream().filter(entry -> entry.getValue() == oldNode).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            variables.forEach(variable -> context.variableSources.put(variable, newNode));
            return new JoinGraph(newNode);
        }
    }
}

