/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RemoveRedundantDistinctAggregation
implements PlanOptimizer {
    private boolean isEnabledForTesting;

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.isRemoveRedundantDistinctAggregationEnabled(session);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.isEnabled(session)) {
            Rewriter rewriter = new Rewriter();
            PlanWithProperties result = rewriter.accept(plan);
            return PlanOptimizerResult.optimizerResult(result.getNode(), rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends InternalPlanVisitor<PlanWithProperties, Void> {
        private boolean planChanged;

        private Rewriter() {
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanWithProperties visitPlan(PlanNode node, Void context) {
            return this.planAndRecplace(node, false);
        }

        public PlanWithProperties visitAggregation(AggregationNode node, Void context) {
            PlanWithProperties child = this.accept(node.getSource());
            if (AggregationNode.isDistinct((AggregationNode)node)) {
                if (child.getProperties().stream().anyMatch(node.getGroupingKeys()::containsAll)) {
                    this.planChanged = true;
                    return child;
                }
            }
            ImmutableList.Builder properties = ImmutableList.builder();
            if (node.getGroupingSetCount() == 1 && !node.getGroupingKeys().isEmpty()) {
                properties.add(node.getGroupingKeys().stream().collect(ImmutableSet.toImmutableSet()));
            }
            PlanNode newAggregation = node.replaceChildren((List)ImmutableList.of((Object)child.getNode()));
            return new PlanWithProperties(newAggregation, (List<Set<VariableReferenceExpression>>)properties.build());
        }

        public PlanWithProperties visitProject(ProjectNode node, Void context) {
            return this.planAndRecplace((PlanNode)node, true);
        }

        private PlanWithProperties accept(PlanNode node) {
            PlanWithProperties result = (PlanWithProperties)node.accept((PlanVisitor)this, null);
            return new PlanWithProperties(result.getNode().assignStatsEquivalentPlanNode(node.getStatsEquivalentPlanNode()), result.getProperties());
        }

        private PlanWithProperties planAndRecplace(PlanNode node, boolean passProperties) {
            List children = (List)node.getSources().stream().map(this::accept).collect(ImmutableList.toImmutableList());
            PlanNode result = ChildReplacer.replaceChildren(node, (List)children.stream().map(PlanWithProperties::getNode).collect(ImmutableList.toImmutableList()));
            if (!passProperties) {
                return new PlanWithProperties(result, (List<Set<VariableReferenceExpression>>)ImmutableList.of());
            }
            ImmutableList.Builder properties = ImmutableList.builder();
            children.stream().map(PlanWithProperties::getProperties).forEach(arg_0 -> ((ImmutableList.Builder)properties).addAll(arg_0));
            return new PlanWithProperties(result, (List<Set<VariableReferenceExpression>>)properties.build());
        }
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final List<Set<VariableReferenceExpression>> distinctVariableSet;

        public PlanWithProperties(PlanNode node, List<Set<VariableReferenceExpression>> distinctVariableSet) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.distinctVariableSet = Objects.requireNonNull(distinctVariableSet, "StreamProperties is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public List<Set<VariableReferenceExpression>> getProperties() {
            return this.distinctVariableSet;
        }
    }
}

