/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;

public interface PlanOptimizer {
    public PlanOptimizerResult optimize(PlanNode var1, Session var2, TypeProvider var3, VariableAllocator var4, PlanNodeIdAllocator var5, WarningCollector var6);

    default public boolean isEnabled(Session session) {
        return true;
    }

    default public boolean isCostBased(Session session) {
        return false;
    }

    default public String getStatsSource() {
        return null;
    }

    default public void setEnabledForTesting(boolean isSet) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isApplicable(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        this.setEnabledForTesting(true);
        boolean isApplicable = false;
        try {
            PlanOptimizerResult optimizerResult = this.optimize(plan, session, types, variableAllocator, idAllocator, warningCollector);
            isApplicable = optimizerResult.isOptimizerTriggered();
            return isApplicable;
        }
        finally {
            this.setEnabledForTesting(false);
            return isApplicable;
        }
    }
}

