/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Objects;

public class ExternalCallExpressionChecker
implements RowExpressionVisitor<Boolean, Void> {
    private final FunctionAndTypeManager functionAndTypeManager;

    public ExternalCallExpressionChecker(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    public Boolean visitCall(CallExpression call, Void context) {
        FunctionMetadata functionMetadata = this.functionAndTypeManager.getFunctionMetadata(call.getFunctionHandle());
        if (functionMetadata.getImplementationType().isExternalExecution()) {
            return true;
        }
        return call.getArguments().stream().anyMatch(argument -> (Boolean)argument.accept((RowExpressionVisitor)this, null));
    }

    public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
        return false;
    }

    public Boolean visitConstant(ConstantExpression literal, Void context) {
        return false;
    }

    public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
        return false;
    }

    public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
        return false;
    }

    public Boolean visitSpecialForm(SpecialFormExpression specialForm, Void context) {
        return specialForm.getArguments().stream().anyMatch(argument -> (Boolean)argument.accept((RowExpressionVisitor)this, null));
    }
}

