/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeDecorrelator;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToLateralNode
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private final StandardFunctionResolution functionResolution;
    private final LogicalRowExpressions logicalRowExpressions;

    public TransformExistsApplyToLateralNode(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)functionAndTypeManager);
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        RowExpression expression = (RowExpression)Iterables.getOnlyElement((Iterable)parent.getSubqueryAssignments().getExpressions());
        if (!(expression instanceof ExistsExpression)) {
            return Rule.Result.empty();
        }
        Optional<PlanNode> nonDefaultAggregation = this.rewriteToNonDefaultAggregation(parent, context);
        return nonDefaultAggregation.map(Rule.Result::ofPlanNode).orElseGet(() -> Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context)));
    }

    private Optional<PlanNode> rewriteToNonDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Preconditions.checkState((boolean)applyNode.getSubquery().getOutputVariables().isEmpty(), (Object)"Expected subquery output variables to be pruned");
        VariableReferenceExpression exists = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)applyNode.getSubqueryAssignments().getVariables());
        VariableReferenceExpression subqueryTrue = context.getVariableAllocator().newVariable(exists.getSourceLocation(), "subqueryTrue", (Type)BooleanType.BOOLEAN);
        Assignments.Builder assignments = Assignments.builder();
        assignments.putAll(AssignmentUtils.identityAssignments(applyNode.getInput().getOutputVariables()));
        assignments.put(exists, (RowExpression)Expressions.specialForm(SpecialFormExpression.Form.COALESCE, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)subqueryTrue, (Object)LogicalRowExpressions.FALSE_CONSTANT)));
        ProjectNode subquery = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new LimitNode(applyNode.getSourceLocation(), context.getIdAllocator().getNextId(), applyNode.getSubquery(), 1L, LimitNode.Step.FINAL), Assignments.of((VariableReferenceExpression)subqueryTrue, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT));
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(context.getIdAllocator(), context.getVariableAllocator(), context.getLookup(), this.logicalRowExpressions);
        if (!decorrelator.decorrelateFilters((PlanNode)subquery, applyNode.getCorrelation()).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new LateralJoinNode(applyNode.getSourceLocation(), applyNode.getId(), applyNode.getInput(), (PlanNode)subquery, applyNode.getCorrelation(), LateralJoinNode.Type.LEFT, applyNode.getOriginSubqueryError()), assignments.build()));
    }

    private PlanNode rewriteToDefaultAggregation(ApplyNode parent, Rule.Context context) {
        VariableReferenceExpression count = context.getVariableAllocator().newVariable("count", (Type)BigintType.BIGINT);
        VariableReferenceExpression exists = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)parent.getSubqueryAssignments().getVariables());
        return new LateralJoinNode(parent.getSourceLocation(), parent.getId(), parent.getInput(), (PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new AggregationNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), parent.getSubquery(), (Map)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(new CallExpression(exists.getSourceLocation(), "count", this.functionResolution.countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty()), Assignments.of((VariableReferenceExpression)exists, (RowExpression)Expressions.comparisonExpression(this.functionResolution, OperatorType.GREATER_THAN, (RowExpression)count, (RowExpression)new ConstantExpression((Object)0L, (Type)BigintType.BIGINT)))), parent.getCorrelation(), LateralJoinNode.Type.INNER, parent.getOriginSubqueryError());
    }
}

