/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TransformDistinctInnerJoinToRightEarlyOutJoin
implements Rule<AggregationNode> {
    private static final Capture<JoinNode> JOIN = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(AggregationNode::isDistinct).with(Patterns.source().matching(Patterns.join().capturedAs(JOIN).with(Patterns.Join.type().matching(type -> type == JoinType.INNER))));

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isInPredicatesAsInnerJoinsEnabled(session) && SystemSessionProperties.isExploitConstraints(session) && SystemSessionProperties.getJoinReorderingStrategy(session) == FeaturesConfig.JoinReorderingStrategy.AUTOMATIC;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        JoinNode innerJoin = (JoinNode)((Object)captures.get(JOIN));
        if (!this.canAggregationBePushedDown(aggregationNode, innerJoin, context)) {
            return Rule.Result.empty();
        }
        AggregationNode aggregationBelowJoin = new AggregationNode(innerJoin.getLeft().getSourceLocation(), context.getIdAllocator().getNextId(), innerJoin.getLeft(), (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)innerJoin.getLeft().getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
        JoinNode newInnerJoin = new JoinNode(innerJoin.getSourceLocation(), context.getIdAllocator().getNextId(), innerJoin.getType(), (PlanNode)aggregationBelowJoin, innerJoin.getRight(), innerJoin.getCriteria(), innerJoin.getOutputVariables(), innerJoin.getFilter(), innerJoin.getLeftHashVariable(), innerJoin.getRightHashVariable(), innerJoin.getDistributionType(), innerJoin.getDynamicFilters());
        AggregationNode newDistinctNode = new AggregationNode(aggregationNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)newInnerJoin, aggregationNode.getAggregations(), aggregationNode.getGroupingSets(), aggregationNode.getPreGroupedVariables(), aggregationNode.getStep(), aggregationNode.getHashVariable(), aggregationNode.getGroupIdVariable(), aggregationNode.getAggregationId());
        return Rule.Result.ofPlanNode((PlanNode)newDistinctNode);
    }

    private boolean canAggregationBePushedDown(AggregationNode aggregationNode, JoinNode joinNode, Rule.Context context) {
        if (!context.getLogicalPropertiesProvider().isPresent() || !((GroupReference)joinNode.getLeft()).getLogicalProperties().isPresent()) {
            return false;
        }
        if (joinNode.isCrossJoin() || this.isJoinCardinalityReducing(joinNode, context)) {
            return false;
        }
        ImmutableSet groupingVariables = ImmutableSet.copyOf((Collection)aggregationNode.getGroupingKeys());
        ImmutableSet joinLeftInputVariables = ImmutableSet.copyOf((Collection)joinNode.getLeft().getOutputVariables());
        LogicalProperties joinLeftInputLogicalProperties = ((GroupReference)joinNode.getLeft()).getLogicalProperties().get();
        LogicalProperties aggregationNodelogicalProperties = context.getLogicalPropertiesProvider().get().getAggregationProperties(aggregationNode);
        if (!aggregationNodelogicalProperties.canBeHomogenized((Set)joinLeftInputVariables, (Set)groupingVariables)) {
            return false;
        }
        return !joinLeftInputLogicalProperties.isDistinct((Set)joinLeftInputVariables);
    }

    private boolean isJoinCardinalityReducing(JoinNode joinNode, Rule.Context context) {
        StatsProvider stats = context.getStatsProvider();
        PlanNodeStatsEstimate joinStats = stats.getStats(joinNode);
        PlanNodeStatsEstimate leftStats = stats.getStats(joinNode.getLeft());
        double inputBytes = leftStats.getOutputSizeInBytes(joinNode.getLeft());
        double outputBytes = joinStats.getOutputSizeInBytes(joinNode);
        return outputBytes <= inputBytes * SystemSessionProperties.getPushAggregationBelowJoinByteReductionThreshold(context.getSession());
    }
}

