/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.AbstractJoinNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveUnsupportedDynamicFilters
implements PlanOptimizer {
    private final LogicalRowExpressions logicalRowExpressions;

    public RemoveUnsupportedDynamicFilters(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)functionAndTypeManager);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Rewriter rewriter = new Rewriter();
        PlanWithConsumedDynamicFilters result = (PlanWithConsumedDynamicFilters)plan.accept((PlanVisitor)rewriter, (Object)ImmutableSet.of());
        return PlanOptimizerResult.optimizerResult(result.getNode(), rewriter.isPlanChanged());
    }

    private static class PlanWithConsumedDynamicFilters {
        private final PlanNode node;
        private final Set<String> consumedDynamicFilterIds;

        PlanWithConsumedDynamicFilters(PlanNode node, Set<String> consumedDynamicFilterIds) {
            this.node = node;
            this.consumedDynamicFilterIds = ImmutableSet.copyOf(consumedDynamicFilterIds);
        }

        PlanNode getNode() {
            return this.node;
        }

        Set<String> getConsumedDynamicFilterIds() {
            return this.consumedDynamicFilterIds;
        }
    }

    private static class JoinDynamicFilterResult {
        private final PlanNode probe;
        private final PlanNode build;
        private final Map<String, VariableReferenceExpression> dynamicFilters;
        private final Set<String> consumed;

        public JoinDynamicFilterResult(PlanNode probe, PlanNode build, Map<String, VariableReferenceExpression> dynamicFilters, Set<String> consumed) {
            this.probe = probe;
            this.build = build;
            this.dynamicFilters = ImmutableMap.copyOf(dynamicFilters);
            this.consumed = ImmutableSet.copyOf(consumed);
        }

        public PlanNode getProbe() {
            return this.probe;
        }

        public PlanNode getBuild() {
            return this.build;
        }

        public Map<String, VariableReferenceExpression> getDynamicFilters() {
            return this.dynamicFilters;
        }

        public Set<String> getConsumed() {
            return this.consumed;
        }
    }

    private class Rewriter
    extends InternalPlanVisitor<PlanWithConsumedDynamicFilters, Set<String>> {
        boolean planChanged;

        private Rewriter() {
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }

        public PlanWithConsumedDynamicFilters visitPlan(PlanNode node, Set<String> allowedDynamicFilterIds) {
            List children = (List)node.getSources().stream().map(source -> (PlanWithConsumedDynamicFilters)source.accept((PlanVisitor)this, (Object)allowedDynamicFilterIds)).collect(ImmutableList.toImmutableList());
            PlanNode result = ChildReplacer.replaceChildren(node, children.stream().map(PlanWithConsumedDynamicFilters::getNode).collect(Collectors.toList()));
            Set consumedDynamicFilterIds = (Set)children.stream().map(PlanWithConsumedDynamicFilters::getConsumedDynamicFilterIds).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            return new PlanWithConsumedDynamicFilters(result, consumedDynamicFilterIds);
        }

        @Override
        public PlanWithConsumedDynamicFilters visitJoin(JoinNode node, Set<String> allowedDynamicFilterIds) {
            JoinDynamicFilterResult joinDynamicFilterResult = this.extractDynamicFilterFromJoin(node, allowedDynamicFilterIds);
            if (!(joinDynamicFilterResult.getProbe().equals(node.getLeft()) && joinDynamicFilterResult.getBuild().equals(node.getRight()) && joinDynamicFilterResult.getDynamicFilters().equals(node.getDynamicFilters()))) {
                Optional<RowExpression> filter = node.getFilter().map(this::removeAllDynamicFilters).filter(expression -> !expression.equals((Object)LogicalRowExpressions.TRUE_CONSTANT));
                return new PlanWithConsumedDynamicFilters(new JoinNode(node.getSourceLocation(), node.getId(), node.getType(), joinDynamicFilterResult.getProbe(), joinDynamicFilterResult.getBuild(), node.getCriteria(), node.getOutputVariables(), filter, node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType(), joinDynamicFilterResult.getDynamicFilters()), (Set<String>)ImmutableSet.copyOf(joinDynamicFilterResult.getConsumed()));
            }
            return new PlanWithConsumedDynamicFilters(node, (Set<String>)ImmutableSet.copyOf(joinDynamicFilterResult.getConsumed()));
        }

        @Override
        public PlanWithConsumedDynamicFilters visitSemiJoin(SemiJoinNode node, Set<String> allowedDynamicFilterIds) {
            JoinDynamicFilterResult joinDynamicFilterResult = this.extractDynamicFilterFromJoin(node, allowedDynamicFilterIds);
            if (!(joinDynamicFilterResult.getProbe().equals(node.getSource()) && joinDynamicFilterResult.getBuild().equals(node.getFilteringSource()) && joinDynamicFilterResult.getDynamicFilters().equals(node.getDynamicFilters()))) {
                return new PlanWithConsumedDynamicFilters(new SemiJoinNode(node.getSourceLocation(), node.getId(), joinDynamicFilterResult.getProbe(), joinDynamicFilterResult.getBuild(), node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable(), node.getSemiJoinOutput(), node.getSourceHashVariable(), node.getFilteringSourceHashVariable(), node.getDistributionType(), joinDynamicFilterResult.getDynamicFilters()), (Set<String>)ImmutableSet.copyOf(joinDynamicFilterResult.getConsumed()));
            }
            return new PlanWithConsumedDynamicFilters(node, (Set<String>)ImmutableSet.copyOf(joinDynamicFilterResult.getConsumed()));
        }

        private JoinDynamicFilterResult extractDynamicFilterFromJoin(AbstractJoinNode node, Set<String> allowedDynamicFilterIds) {
            ImmutableSet allowedDynamicFilterIdsProbeSide = ImmutableSet.builder().addAll(node.getDynamicFilters().keySet()).addAll(allowedDynamicFilterIds).build();
            PlanWithConsumedDynamicFilters leftResult = (PlanWithConsumedDynamicFilters)node.getProbe().accept((PlanVisitor)this, (Object)allowedDynamicFilterIdsProbeSide);
            Set<String> consumedProbeSide = leftResult.getConsumedDynamicFilterIds();
            Map<String, VariableReferenceExpression> dynamicFilters = node.getDynamicFilters().entrySet().stream().filter(entry -> consumedProbeSide.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            PlanWithConsumedDynamicFilters rightResult = (PlanWithConsumedDynamicFilters)node.getBuild().accept((PlanVisitor)this, allowedDynamicFilterIds);
            HashSet<String> consumed = new HashSet<String>(rightResult.getConsumedDynamicFilterIds());
            consumed.addAll(consumedProbeSide);
            consumed.removeAll(dynamicFilters.keySet());
            PlanNode left = leftResult.getNode();
            PlanNode right = rightResult.getNode();
            return new JoinDynamicFilterResult(left, right, dynamicFilters, consumed);
        }

        public PlanWithConsumedDynamicFilters visitFilter(FilterNode node, Set<String> allowedDynamicFilterIds) {
            RowExpression modified;
            PlanWithConsumedDynamicFilters result = (PlanWithConsumedDynamicFilters)node.getSource().accept((PlanVisitor)this, allowedDynamicFilterIds);
            RowExpression original = node.getPredicate();
            ImmutableSet.Builder consumedDynamicFilterIds = ImmutableSet.builder().addAll(result.getConsumedDynamicFilterIds());
            PlanNode source = result.getNode();
            if (source instanceof TableScanNode) {
                this.planChanged = true;
                modified = this.removeDynamicFilters(original, allowedDynamicFilterIds, (ImmutableSet.Builder<String>)consumedDynamicFilterIds);
            } else {
                modified = this.removeAllDynamicFilters(original);
            }
            if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)modified)) {
                return new PlanWithConsumedDynamicFilters(source, (Set<String>)consumedDynamicFilterIds.build());
            }
            if (!original.equals((Object)modified) || source != node.getSource()) {
                return new PlanWithConsumedDynamicFilters((PlanNode)new FilterNode(source.getSourceLocation(), node.getId(), source, modified), (Set<String>)consumedDynamicFilterIds.build());
            }
            return new PlanWithConsumedDynamicFilters((PlanNode)node, (Set<String>)consumedDynamicFilterIds.build());
        }

        private RowExpression removeDynamicFilters(RowExpression expression, Set<String> allowedDynamicFilterIds, ImmutableSet.Builder<String> consumedDynamicFilterIds) {
            return RemoveUnsupportedDynamicFilters.this.logicalRowExpressions.combineConjuncts((Collection)LogicalRowExpressions.extractConjuncts((RowExpression)expression).stream().map(DynamicFilters::removeNestedDynamicFilters).filter(conjunct -> DynamicFilters.getPlaceholder((RowExpression)conjunct).map(placeholder -> {
                if (allowedDynamicFilterIds.contains(placeholder.getId())) {
                    consumedDynamicFilterIds.add((Object)placeholder.getId());
                    return true;
                }
                return false;
            }).orElse(true)).collect(ImmutableList.toImmutableList()));
        }

        private RowExpression removeAllDynamicFilters(RowExpression expression) {
            RowExpression rewrittenExpression = DynamicFilters.removeNestedDynamicFilters((RowExpression)expression);
            DynamicFilters.DynamicFilterExtractResult extractResult = DynamicFilters.extractDynamicFilters((RowExpression)rewrittenExpression);
            if (extractResult.getDynamicConjuncts().isEmpty()) {
                return rewrittenExpression;
            }
            return RemoveUnsupportedDynamicFilters.this.logicalRowExpressions.combineConjuncts((Collection)extractResult.getStaticConjuncts());
        }
    }
}

