/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.joni.Regex;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;

public class PullUpExpressionInLambdaRules {
    private final RowExpressionDeterminismEvaluator determinismEvaluator;
    private final FunctionResolution functionResolution;

    public PullUpExpressionInLambdaRules(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    private static Set<RowExpression> getCandidateRowExpression(RowExpressionDeterminismEvaluator determinismEvaluator, FunctionResolution functionResolution, List<VariableReferenceExpression> inputVariables, RowExpression rowExpression) {
        ImmutableSet.Builder candidateBuilder = ImmutableSet.builder();
        ValidExpressionExtractor validCallExpressionExtractor = new ValidExpressionExtractor(determinismEvaluator, functionResolution, inputVariables, (ImmutableSet.Builder<RowExpression>)candidateBuilder);
        rowExpression.accept((RowExpressionVisitor)validCallExpressionExtractor, (Object)false);
        return (Set)candidateBuilder.build().stream().filter(x -> !VariablesExtractor.extractAll(x).isEmpty()).collect(ImmutableSet.toImmutableSet());
    }

    public boolean isRuleEnabled(Session session) {
        return SystemSessionProperties.isPullExpressionFromLambdaEnabled(session);
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.filterNodeRule(), this.projectNodeRule());
    }

    public Rule<FilterNode> filterNodeRule() {
        return new PullUpExpressionInLambdaFilterNodeRule();
    }

    public Rule<ProjectNode> projectNodeRule() {
        return new PullUpExpressionInLambdaProjectNodeRule();
    }

    private static class ExpressionRewriter
    implements RowExpressionVisitor<RowExpression, Void> {
        private final Map<RowExpression, VariableReferenceExpression> expressionMap;

        public ExpressionRewriter(Map<RowExpression, VariableReferenceExpression> expressionMap) {
            this.expressionMap = ImmutableMap.copyOf(expressionMap);
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            List rewrittenArguments = (List)call.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList());
            CallExpression rewritten = new CallExpression(call.getSourceLocation(), call.getDisplayName(), call.getFunctionHandle(), call.getType(), rewrittenArguments);
            if (this.expressionMap.containsKey(rewritten)) {
                return (RowExpression)this.expressionMap.get(rewritten);
            }
            if (this.rowExpressionsNotChanged(call.getArguments(), rewrittenArguments)) {
                return call;
            }
            return rewritten;
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getSourceLocation(), lambda.getArgumentTypes(), lambda.getArguments(), (RowExpression)lambda.getBody().accept((RowExpressionVisitor)this, (Object)context));
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            List rewrittenArguments = (List)specialForm.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList());
            SpecialFormExpression rewritten = new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), rewrittenArguments);
            if (this.expressionMap.containsKey(rewritten)) {
                return (RowExpression)this.expressionMap.get(rewritten);
            }
            if (this.rowExpressionsNotChanged(specialForm.getArguments(), rewrittenArguments)) {
                return specialForm;
            }
            return rewritten;
        }

        private boolean rowExpressionsNotChanged(List<RowExpression> original, List<RowExpression> rewritten) {
            Preconditions.checkArgument((original.size() == rewritten.size() ? 1 : 0) != 0);
            return IntStream.range(0, original.size()).boxed().allMatch(idx -> ((RowExpression)original.get((int)idx)).equals(rewritten.get((int)idx)));
        }
    }

    private static class ValidExpressionExtractor
    implements RowExpressionVisitor<Boolean, Boolean> {
        private static final List<SpecialFormExpression.Form> UNSUPPORTED_TYPES = ImmutableList.of((Object)SpecialFormExpression.Form.BIND);
        private static final List<Class<?>> SUPPORTED_JAVA_TYPES = ImmutableList.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class, Block.class);
        private final RowExpressionDeterminismEvaluator determinismEvaluator;
        private final FunctionResolution functionResolution;
        private final List<VariableReferenceExpression> inputVariables;
        private final ImmutableSet.Builder<RowExpression> candidates;

        public ValidExpressionExtractor(RowExpressionDeterminismEvaluator determinismEvaluator, FunctionResolution functionResolution, List<VariableReferenceExpression> inputVariables, ImmutableSet.Builder<RowExpression> candidates) {
            this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
            this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
            this.inputVariables = Objects.requireNonNull(inputVariables, "inputVariables is null");
            this.candidates = Objects.requireNonNull(candidates, "candidates is null");
        }

        public Boolean visitCall(CallExpression call, Boolean context) {
            if (this.functionResolution.isTryFunction(call.getFunctionHandle()) || this.functionResolution.isSubscriptFunction(call.getFunctionHandle())) {
                return false;
            }
            Map validRowExpressionMap = (Map)call.getArguments().stream().distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> (Boolean)x.accept((RowExpressionVisitor)this, (Object)context)));
            if (context.equals(Boolean.TRUE)) {
                boolean allArgumentsValid = validRowExpressionMap.values().stream().allMatch(x -> x.equals(Boolean.TRUE));
                if (!allArgumentsValid) {
                    this.candidates.addAll((Iterable)validRowExpressionMap.entrySet().stream().filter(x -> ((Boolean)x.getValue()).equals(Boolean.TRUE)).map(Map.Entry::getKey).map(x -> this.getArgumentForRegexTypeExpression((RowExpression)x)).filter(ValidExpressionExtractor::isSupportedExpression).collect(ImmutableList.toImmutableList()));
                }
                return allArgumentsValid && this.determinismEvaluator.isDeterministic((RowExpression)call);
            }
            return false;
        }

        private static List<RowExpression> getValidArguments(SpecialFormExpression specialForm) {
            SpecialFormExpression.Form form = specialForm.getForm();
            Object validArgument = form.equals((Object)SpecialFormExpression.Form.IF) || form.equals((Object)SpecialFormExpression.Form.COALESCE) || form.equals((Object)SpecialFormExpression.Form.WHEN) ? ImmutableList.of(specialForm.getArguments().get(0)) : (form.equals((Object)SpecialFormExpression.Form.SWITCH) ? ImmutableList.of(specialForm.getArguments().get(0), specialForm.getArguments().get(1)) : specialForm.getArguments());
            return validArgument;
        }

        private static RowExpression getArgumentOfWhen(RowExpression expression) {
            if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm().equals((Object)SpecialFormExpression.Form.WHEN)) {
                return ValidExpressionExtractor.getArgumentOfWhen((RowExpression)((SpecialFormExpression)expression).getArguments().get(0));
            }
            return expression;
        }

        private RowExpression getArgumentForRegexTypeExpression(RowExpression rowExpression) {
            if (rowExpression.getType().getJavaType() == Regex.class && rowExpression instanceof CallExpression && (this.functionResolution.isCastFunction(((CallExpression)rowExpression).getFunctionHandle()) || this.functionResolution.isLikePatternFunction(((CallExpression)rowExpression).getFunctionHandle()))) {
                CallExpression castExpression = (CallExpression)rowExpression;
                return this.getArgumentForRegexTypeExpression((RowExpression)castExpression.getArguments().get(0));
            }
            return rowExpression;
        }

        public Boolean visitSpecialForm(SpecialFormExpression specialForm, Boolean context) {
            if (UNSUPPORTED_TYPES.contains(specialForm.getForm())) {
                return false;
            }
            List<RowExpression> validArguments = ValidExpressionExtractor.getValidArguments(specialForm);
            Map validRowExpressionMap = (Map)specialForm.getArguments().stream().distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> validArguments.contains(x) ? (Boolean)x.accept((RowExpressionVisitor)this, (Object)context) : Boolean.valueOf(false)));
            if (context.equals(Boolean.TRUE)) {
                boolean allArgumentsValid = validRowExpressionMap.values().stream().allMatch(x -> x.equals(Boolean.TRUE));
                if (!allArgumentsValid) {
                    this.candidates.addAll((Iterable)validRowExpressionMap.entrySet().stream().filter(x -> ((Boolean)x.getValue()).equals(Boolean.TRUE)).map(Map.Entry::getKey).map(ValidExpressionExtractor::getArgumentOfWhen).filter(ValidExpressionExtractor::isSupportedExpression).collect(ImmutableList.toImmutableList()));
                }
                return allArgumentsValid && this.determinismEvaluator.isDeterministic((RowExpression)specialForm);
            }
            return false;
        }

        public Boolean visitLambda(LambdaDefinitionExpression lambda, Boolean context) {
            if (((Boolean)lambda.getBody().accept((RowExpressionVisitor)this, (Object)true)).booleanValue() && ValidExpressionExtractor.isSupportedExpression(lambda.getBody())) {
                this.candidates.add((Object)lambda.getBody());
            }
            return false;
        }

        public Boolean visitVariableReference(VariableReferenceExpression reference, Boolean context) {
            return this.inputVariables.contains(reference);
        }

        public Boolean visitConstant(ConstantExpression literal, Boolean context) {
            return true;
        }

        public Boolean visitInputReference(InputReferenceExpression reference, Boolean context) {
            return false;
        }

        private static boolean isSupportedExpression(RowExpression expression) {
            return (expression instanceof CallExpression || expression instanceof SpecialFormExpression && !((SpecialFormExpression)expression).getForm().equals((Object)SpecialFormExpression.Form.WHEN)) && SUPPORTED_JAVA_TYPES.contains(expression.getType().getJavaType());
        }
    }

    private final class PullUpExpressionInLambdaFilterNodeRule
    implements Rule<FilterNode> {
        private PullUpExpressionInLambdaFilterNodeRule() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return PullUpExpressionInLambdaRules.this.isRuleEnabled(session);
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            RowExpression predicate = filterNode.getPredicate();
            List inputVariables = filterNode.getSource().getOutputVariables();
            Set candidates = PullUpExpressionInLambdaRules.getCandidateRowExpression(PullUpExpressionInLambdaRules.this.determinismEvaluator, PullUpExpressionInLambdaRules.this.functionResolution, inputVariables, predicate);
            if (candidates.isEmpty()) {
                return Rule.Result.empty();
            }
            Map mapping = (Map)candidates.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> context.getVariableAllocator().newVariable(x)));
            ImmutableMap.Builder pulledExpressionMapBuilder = ImmutableMap.builder();
            pulledExpressionMapBuilder.putAll((Map)mapping.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey)));
            RowExpression rewrittenExpression = (RowExpression)predicate.accept((RowExpressionVisitor)new ExpressionRewriter(mapping), null);
            PlanNode planNode = PlannerUtils.addProjections(filterNode.getSource(), context.getIdAllocator(), (Map<VariableReferenceExpression, RowExpression>)pulledExpressionMapBuilder.build());
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new FilterNode(filterNode.getSourceLocation(), context.getIdAllocator().getNextId(), planNode, rewrittenExpression), AssignmentUtils.identityAssignments(filterNode.getOutputVariables())));
        }
    }

    private final class PullUpExpressionInLambdaProjectNodeRule
    implements Rule<ProjectNode> {
        private PullUpExpressionInLambdaProjectNodeRule() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return PullUpExpressionInLambdaRules.this.isRuleEnabled(session);
        }

        @Override
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        @Override
        public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
            List inputVariables = node.getSource().getOutputVariables();
            ImmutableMap.Builder pulledExpressionMapBuilder = ImmutableMap.builder();
            Assignments.Builder newProjectWithLambda = Assignments.builder();
            for (Map.Entry entry : node.getAssignments().getMap().entrySet()) {
                RowExpression rowExpression = (RowExpression)entry.getValue();
                Set candidates = PullUpExpressionInLambdaRules.getCandidateRowExpression(PullUpExpressionInLambdaRules.this.determinismEvaluator, PullUpExpressionInLambdaRules.this.functionResolution, inputVariables, rowExpression);
                if (candidates.isEmpty()) {
                    newProjectWithLambda.put((VariableReferenceExpression)entry.getKey(), (RowExpression)entry.getValue());
                    continue;
                }
                Map mapping = (Map)candidates.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), x -> context.getVariableAllocator().newVariable(x)));
                pulledExpressionMapBuilder.putAll((Map)mapping.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey)));
                RowExpression rewrittenExpression = (RowExpression)rowExpression.accept((RowExpressionVisitor)new ExpressionRewriter(mapping), null);
                newProjectWithLambda.put((VariableReferenceExpression)entry.getKey(), rewrittenExpression);
            }
            ImmutableMap pulledExpressionMap = pulledExpressionMapBuilder.build();
            if (pulledExpressionMap.isEmpty()) {
                return Rule.Result.empty();
            }
            PlanNode planNode = PlannerUtils.addProjections(node.getSource(), context.getIdAllocator(), (Map<VariableReferenceExpression, RowExpression>)pulledExpressionMap);
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), planNode, newProjectWithLambda.build()));
        }
    }
}

