/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneMarkDistinctColumns
extends ProjectOffPushDownRule<MarkDistinctNode> {
    public PruneMarkDistinctColumns() {
        super(Patterns.markDistinct());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, MarkDistinctNode markDistinctNode, Set<VariableReferenceExpression> referencedOutputs) {
        if (!referencedOutputs.contains(markDistinctNode.getMarkerVariable())) {
            return Optional.of(markDistinctNode.getSource());
        }
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(variable -> !variable.equals((Object)markDistinctNode.getMarkerVariable())), markDistinctNode.getDistinctVariables().stream(), markDistinctNode.getHashVariable().map(Stream::of).orElse(Stream.empty())}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(idAllocator, (PlanNode)markDistinctNode, requiredInputs);
    }
}

