/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.google.common.base.MoreObjects;
import java.util.Optional;

public final class MaxCardProperty {
    private final Optional<Long> value;

    public MaxCardProperty() {
        this.value = Optional.empty();
    }

    public MaxCardProperty(Optional<Long> value) {
        this.value = value;
    }

    public MaxCardProperty(Long value) {
        this(Optional.of(value));
    }

    public MaxCardProperty(MaxCardProperty maxCardProperty) {
        this(maxCardProperty.getValue());
    }

    public Optional<Long> getValue() {
        return this.value;
    }

    public boolean moreGeneral(MaxCardProperty otherMaxCardProperty) {
        return !this.value.isPresent() && !otherMaxCardProperty.value.isPresent() || this.value.isPresent() && (!otherMaxCardProperty.value.isPresent() || otherMaxCardProperty.value.get() >= this.value.get());
    }

    public MaxCardProperty getMinMaxCardProperty(long value) {
        if (!this.value.isPresent() || this.value.get().compareTo(value) > 0) {
            return new MaxCardProperty(Optional.of(value));
        }
        return this;
    }

    public MaxCardProperty getMinMaxCardProperty(MaxCardProperty maxCardProperty) {
        if (!maxCardProperty.value.isPresent()) {
            return this;
        }
        return this.getMinMaxCardProperty(maxCardProperty.value.get());
    }

    public boolean isAtMostOne() {
        return this.isAtMost(1L);
    }

    public boolean isAtMost(long n) {
        if (this.value.isPresent()) {
            return this.value.get() <= n;
        }
        return false;
    }

    public static MaxCardProperty multiplyMaxCard(MaxCardProperty thisMaxCardProperty, MaxCardProperty otherMaxCardProperty) {
        if (!thisMaxCardProperty.value.isPresent() || !otherMaxCardProperty.value.isPresent()) {
            return new MaxCardProperty();
        }
        return new MaxCardProperty(Optional.of(thisMaxCardProperty.value.get() * otherMaxCardProperty.value.get()));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value.isPresent() ? this.value.get() : "null").toString();
    }
}

