/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.optimizations.OptimizerStats;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public class OptimizerStatsRecorder {
    private final Map<Class<?>, OptimizerStats> stats = new HashMap();

    public void register(PlanOptimizer optimizer) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        Preconditions.checkArgument((!optimizer.getClass().isAnonymousClass() ? 1 : 0) != 0);
        this.stats.put(optimizer.getClass(), new OptimizerStats());
    }

    public void record(PlanOptimizer optimizer, long nanos) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        OptimizerStats optimizerStats = Objects.requireNonNull(this.stats.get(optimizer.getClass()), "optimizer is not registered");
        optimizerStats.record(nanos);
    }

    public void recordFailure(PlanOptimizer optimizer) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        OptimizerStats optimizerStats = Objects.requireNonNull(this.stats.get(optimizer.getClass()), "optimizer is not registered");
        optimizerStats.recordFailure();
    }

    public void export(MBeanExporter exporter) {
        for (Map.Entry<Class<?>, OptimizerStats> entry : this.stats.entrySet()) {
            Verify.verify((!entry.getKey().getSimpleName().isEmpty() ? 1 : 0) != 0);
            try {
                exporter.export(this.getName(entry.getKey()), (Object)entry.getValue());
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to export MBean with name '%s'", this.getName(entry.getKey())), e);
            }
        }
    }

    public void unexport(MBeanExporter exporter) {
        for (Class<?> rule : this.stats.keySet()) {
            exporter.unexport(this.getName(rule));
        }
    }

    private String getName(Class<?> key) {
        return ObjectNames.builder(PlanOptimizer.class).withProperty("optimizer", key.getSimpleName()).build();
    }
}

