/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.PlanNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class CanonicalPlan {
    private final PlanNode plan;
    private final PlanCanonicalizationStrategy strategy;

    @JsonCreator
    public CanonicalPlan(@JsonProperty(value="plan") PlanNode plan, @JsonProperty(value="strategy") PlanCanonicalizationStrategy strategy) {
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.strategy = Objects.requireNonNull(strategy, "plan is null");
    }

    @JsonProperty
    public PlanNode getPlan() {
        return this.plan;
    }

    @JsonProperty
    public PlanCanonicalizationStrategy getStrategy() {
        return this.strategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalPlan that = (CanonicalPlan)o;
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.strategy, that.strategy);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.strategy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("plan", (Object)this.plan).add("strategy", (Object)this.strategy).toString();
    }

    public String toString(ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PLAN_SERIALIZATION_ERROR, "Cannot serialize plan to JSON", (Throwable)e);
        }
    }
}

