/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.Constant;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class IsNullCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        RowExpression argument = arguments.get(0);
        if (argument.getType().equals(UnknownType.UNKNOWN)) {
            return Constant.loadBoolean((boolean)true);
        }
        BytecodeNode value = generatorContext.generate(argument, Optional.empty());
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("is null").append(value).pop(argument.getType().getJavaType()).append((BytecodeNode)wasNull);
        block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }
}

