/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.ResolvedSubfield;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StackableAstVisitor;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FunctionArgumentCheckerForAccessControlUtils {
    private static final QualifiedName TRANSFORM = QualifiedName.of((String)"transform");
    private static final QualifiedName CARDINALITY = QualifiedName.of((String)"cardinality");

    private FunctionArgumentCheckerForAccessControlUtils() {
    }

    public static boolean isUnusedArgumentForAccessControl(FunctionCall node, int argumentIndex, ExpressionAnalyzer.Context context) {
        if (node.getName().equals((Object)TRANSFORM)) {
            Preconditions.checkState((node.getArguments().size() == 2 ? 1 : 0) != 0);
            return argumentIndex == 0;
        }
        if (node.getName().equals((Object)CARDINALITY)) {
            Preconditions.checkState((node.getArguments().size() == 1 ? 1 : 0) != 0);
            return argumentIndex == 0;
        }
        return false;
    }

    public static Map<Identifier, ResolvedSubfield> getResolvedLambdaArguments(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<ExpressionAnalyzer.Context> context, Map<NodeRef<Expression>, Type> expressionTypes) {
        ImmutableMap.Builder resolvedLambdaArguments = ImmutableMap.builder();
        if (node.getName().equals((Object)TRANSFORM)) {
            Preconditions.checkState((node.getArguments().size() == 2 ? 1 : 0) != 0);
            if (!(node.getArguments().get(1) instanceof LambdaExpression)) {
                return ImmutableMap.of();
            }
            Expression arrayExpression = (Expression)node.getArguments().get(0);
            LambdaExpression lambdaExpression = (LambdaExpression)node.getArguments().get(1);
            Optional<ResolvedSubfield> resolvedSubfield = FunctionArgumentCheckerForAccessControlUtils.resolveSubfield(arrayExpression, context, expressionTypes);
            if (resolvedSubfield.isPresent()) {
                resolvedLambdaArguments.put((Object)((LambdaArgumentDeclaration)lambdaExpression.getArguments().get(0)).getName(), (Object)resolvedSubfield.get());
            }
        }
        return resolvedLambdaArguments.build();
    }

    public static Optional<ResolvedSubfield> resolveSubfield(Expression node, StackableAstVisitor.StackableAstVisitorContext<ExpressionAnalyzer.Context> context, Map<NodeRef<Expression>, Type> expressionTypes) {
        if (!FunctionArgumentCheckerForAccessControlUtils.isTopMostReference(node, context)) {
            return Optional.empty();
        }
        Scope scope = ((ExpressionAnalyzer.Context)context.getContext()).getScope();
        Expression childNode = node;
        ArrayList<Subfield.NestedField> columnDereferences = new ArrayList<Subfield.NestedField>();
        while (true) {
            QualifiedName childQualifiedName;
            if (childNode instanceof SubscriptExpression) {
                SubscriptExpression subscriptExpression = (SubscriptExpression)childNode;
                Type baseType = expressionTypes.get(NodeRef.of((Node)(childNode = subscriptExpression.getBase())));
                if (baseType == null || !(baseType instanceof RowType)) continue;
                int index = Math.toIntExact(((LongLiteral)subscriptExpression.getIndex()).getValue());
                RowType baseRowType = (RowType)baseType;
                Optional dereference = ((RowType.Field)baseRowType.getFields().get(index - 1)).getName();
                if (!dereference.isPresent()) break;
                columnDereferences.add(new Subfield.NestedField((String)dereference.get()));
                continue;
            }
            if (childNode instanceof DereferenceExpression) {
                childQualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)childNode));
            } else {
                if (!(childNode instanceof Identifier)) break;
                childQualifiedName = QualifiedName.of((String)((Identifier)childNode).getValue());
            }
            if (childQualifiedName != null) {
                Optional<ResolvedSubfield> resolvedSubField;
                Optional<ResolvedField> resolvedField = scope.tryResolveField(childNode, childQualifiedName);
                if (resolvedField.isPresent() && !((ResolvedField)resolvedField.get()).getField().getOriginTable().isPresent() && (resolvedSubField = Optional.ofNullable(((ExpressionAnalyzer.Context)context.getContext()).getResolvedLambdaArguments().get(childNode))).isPresent()) {
                    resolvedField = Optional.of(resolvedSubField.get().getResolvedField());
                    columnDereferences.addAll(Lists.reverse((List)resolvedSubField.get().getSubfield().getPath()));
                }
                if (resolvedField.isPresent() && ((ResolvedField)resolvedField.get()).getField().getOriginColumnName().isPresent() && ((ResolvedField)resolvedField.get()).getField().getOriginTable().isPresent()) {
                    Collections.reverse(columnDereferences);
                    return Optional.of(new ResolvedSubfield((ResolvedField)resolvedField.get(), new Subfield((String)resolvedField.get().getField().getOriginColumnName().get(), columnDereferences)));
                }
            }
            if (!(childNode instanceof DereferenceExpression)) break;
            columnDereferences.add(new Subfield.NestedField(((DereferenceExpression)childNode).getField().getValue()));
            childNode = ((DereferenceExpression)childNode).getBase();
        }
        return Optional.empty();
    }

    public static boolean isDereferenceOrSubscript(Expression node) {
        return node instanceof DereferenceExpression || node instanceof SubscriptExpression;
    }

    public static boolean isTopMostReference(Expression node, StackableAstVisitor.StackableAstVisitorContext<ExpressionAnalyzer.Context> context) {
        if (!context.getPreviousNode().isPresent()) {
            return true;
        }
        return !FunctionArgumentCheckerForAccessControlUtils.isDereferenceOrSubscript((Expression)context.getPreviousNode().get());
    }
}

