/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

public class SimpleHttpResponseHandlerStats {
    private final IncrementalAverage responseSizeBytes = new IncrementalAverage();
    private AtomicLong requestSuccess = new AtomicLong();
    private AtomicLong requestFailure = new AtomicLong();

    public void responseSize(long responseSizeBytes) {
        this.responseSizeBytes.add(responseSizeBytes);
    }

    public void updateSuccess() {
        this.requestSuccess.incrementAndGet();
    }

    public void updateFailure() {
        this.requestFailure.incrementAndGet();
    }

    @Managed
    public double getResponseSizeBytes() {
        return this.responseSizeBytes.getAverage();
    }

    @Managed
    public long getRequestSuccess() {
        return this.requestSuccess.get();
    }

    @Managed
    public long getRequestFailure() {
        return this.requestFailure.get();
    }

    @ThreadSafe
    public static class IncrementalAverage {
        @GuardedBy(value="this")
        private volatile long count;
        @GuardedBy(value="this")
        private volatile double average;

        public synchronized void add(long value) {
            ++this.count;
            this.average += ((double)value - this.average) / (double)this.count;
        }

        public double getAverage() {
            return this.average;
        }

        public long getCount() {
            return this.count;
        }
    }
}

