/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.server.NodeStatus;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

@Path(value="/v1/heartbeat")
public class ResourceManagerHeartbeatResource {
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final ListeningExecutorService executor;

    @Inject
    public ResourceManagerHeartbeatResource(ResourceManagerClusterStateProvider clusterStateProvider, @ForResourceManager ListeningExecutorService executor) {
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "clusterStateProvider is null");
        this.executor = executor;
    }

    @PUT
    @Consumes(value={"application/json"})
    public void nodeHeartbeat(NodeStatus nodeStatus) {
        this.executor.execute(() -> this.clusterStateProvider.registerNodeHeartbeat(nodeStatus));
    }
}

