/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupState;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public class ResourceGroupInfo {
    private final ResourceGroupId id;
    private final ResourceGroupState state;
    private final SchedulingPolicy schedulingPolicy;
    private final int schedulingWeight;
    private final DataSize softMemoryLimit;
    private final int softConcurrencyLimit;
    private final int hardConcurrencyLimit;
    private final int workersPerQueryLimit;
    private final int maxQueuedQueries;
    private final DataSize memoryUsage;
    private final int numQueuedQueries;
    private final int numRunningQueries;
    private final int numEligibleSubGroups;
    private final List<ResourceGroupInfo> subGroups;
    private final List<QueryStateInfo> runningQueries;

    @ThriftConstructor
    @JsonCreator
    public ResourceGroupInfo(@JsonProperty(value="id") ResourceGroupId id, @JsonProperty(value="state") ResourceGroupState state, @JsonProperty(value="schedulingPolicy") SchedulingPolicy schedulingPolicy, @JsonProperty(value="schedulingWeight") int schedulingWeight, @JsonProperty(value="softMemoryLimit") DataSize softMemoryLimit, @JsonProperty(value="softConcurrencyLimit") int softConcurrencyLimit, @JsonProperty(value="hardConcurrencyLimit") int hardConcurrencyLimit, @JsonProperty(value="maxQueuedQueries") int maxQueuedQueries, @JsonProperty(value="memoryUsage") DataSize memoryUsage, @JsonProperty(value="numQueuedQueries") int numQueuedQueries, @JsonProperty(value="numRunningQueries") int numRunningQueries, @JsonProperty(value="numEligibleSubGroups") int numEligibleSubGroups, @JsonProperty(value="subGroups") List<ResourceGroupInfo> subGroups, @JsonProperty(value="runningQueries") List<QueryStateInfo> runningQueries, @JsonProperty(value="workersPerQueryLimit") int workersPerQueryLimit) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.schedulingPolicy = Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null");
        this.schedulingWeight = schedulingWeight;
        this.softMemoryLimit = Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        this.softConcurrencyLimit = softConcurrencyLimit;
        this.hardConcurrencyLimit = hardConcurrencyLimit;
        this.maxQueuedQueries = maxQueuedQueries;
        this.workersPerQueryLimit = workersPerQueryLimit;
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.numQueuedQueries = numQueuedQueries;
        this.numRunningQueries = numRunningQueries;
        this.numEligibleSubGroups = numEligibleSubGroups;
        this.runningQueries = runningQueries;
        this.subGroups = subGroups;
    }

    @JsonProperty
    @ThriftField(value=1)
    public ResourceGroupId getId() {
        return this.id;
    }

    @JsonProperty
    @ThriftField(value=2)
    public ResourceGroupState getState() {
        return this.state;
    }

    @JsonProperty
    @ThriftField(value=3)
    public SchedulingPolicy getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    @JsonProperty
    @ThriftField(value=4)
    public int getSchedulingWeight() {
        return this.schedulingWeight;
    }

    @JsonProperty
    @ThriftField(value=5)
    public DataSize getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    @JsonProperty
    @ThriftField(value=6)
    public DataSize getMemoryUsage() {
        return this.memoryUsage;
    }

    @JsonProperty
    @ThriftField(value=7)
    public int getSoftConcurrencyLimit() {
        return this.softConcurrencyLimit;
    }

    @JsonProperty
    @ThriftField(value=8)
    public int getHardConcurrencyLimit() {
        return this.hardConcurrencyLimit;
    }

    @JsonProperty
    @ThriftField(value=9)
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @JsonProperty
    @ThriftField(value=10)
    public int getNumQueuedQueries() {
        return this.numQueuedQueries;
    }

    @JsonProperty
    @ThriftField(value=11)
    public int getNumRunningQueries() {
        return this.numRunningQueries;
    }

    @JsonProperty
    @Deprecated
    @ThriftField(value=12)
    public int numAggregatedQueuedQueries() {
        return this.numQueuedQueries;
    }

    @JsonProperty
    @Deprecated
    @ThriftField(value=13)
    public int numAggregatedRunningQueries() {
        return this.numRunningQueries;
    }

    @Deprecated
    @JsonProperty
    @ThriftField(value=14)
    public int getNumEligibleSubGroups() {
        return this.numEligibleSubGroups;
    }

    @JsonProperty
    @Nullable
    @ThriftField(value=15)
    public List<QueryStateInfo> getRunningQueries() {
        return this.runningQueries;
    }

    @JsonProperty
    @Nullable
    @ThriftField(value=16)
    public List<ResourceGroupInfo> getSubGroups() {
        return this.subGroups;
    }

    @JsonProperty
    @ThriftField(value=17)
    public int getWorkersPerQueryLimit() {
        return this.workersPerQueryLimit;
    }
}

