/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.spi.nodestatus.NoOpNodeStatusNotificationProvider;
import com.facebook.presto.spi.nodestatus.NodeStatusNotificationProvider;
import com.facebook.presto.spi.nodestatus.NodeStatusNotificationProviderFactory;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class NodeStatusNotificationManager {
    private static final File NODE_STATUS_NOTIFICATION_CONFIG = new File("etc/node-status-notification.properties");
    private NodeStatusNotificationProviderFactory notificationProviderFactory;
    private NodeStatusNotificationProvider notificationProvider = new NoOpNodeStatusNotificationProvider();
    private boolean isNotificationProviderAdded;

    public void addNodeStatusNotificationProviderFactory(NodeStatusNotificationProviderFactory notificationProviderFactory) {
        this.notificationProviderFactory = Objects.requireNonNull(notificationProviderFactory, "notificationProviderFactory is null");
    }

    public void loadNodeStatusNotificationProvider() throws IOException {
        if (this.notificationProviderFactory == null) {
            return;
        }
        Preconditions.checkState((!this.isNotificationProviderAdded ? 1 : 0) != 0, (Object)"NotificationProvider can only be set once");
        this.notificationProvider = this.notificationProviderFactory.create(this.getConfig());
        this.isNotificationProviderAdded = true;
    }

    private Map<String, String> getConfig() throws IOException {
        if (NODE_STATUS_NOTIFICATION_CONFIG.exists()) {
            return PropertiesUtil.loadProperties(NODE_STATUS_NOTIFICATION_CONFIG);
        }
        return ImmutableMap.of();
    }

    public NodeStatusNotificationProvider getNotificationProvider() {
        return this.notificationProvider;
    }
}

