/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupState;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregatedResourceGroupInfoBuilder {
    private ResourceGroupId id;
    private SchedulingPolicy schedulingPolicy;
    private int schedulingWeight;
    private Map<ResourceGroupId, AggregatedResourceGroupInfoBuilder> subGroupsMap;
    private ImmutableList.Builder<QueryStateInfo> runningQueriesBuilder;
    private static final Map<ResourceGroupState, Integer> resourceGroupStatePreference = ImmutableMap.of((Object)ResourceGroupState.FULL, (Object)1, (Object)ResourceGroupState.CAN_QUEUE, (Object)2, (Object)ResourceGroupState.CAN_RUN, (Object)3);
    private ResourceGroupState state;
    private DataSize softMemoryLimit;
    private int softConcurrencyLimit;
    private int hardConcurrencyLimit;
    private int maxQueuedQueries;
    private long memoryUsageBytes;
    private int numQueuedQueries;
    private int numRunningQueries;
    private int workersPerQueryLimit;

    private void init(ResourceGroupInfo resourceGroupInfo) {
        this.id = Objects.requireNonNull(resourceGroupInfo.getId(), "id is null");
        this.state = Objects.requireNonNull(resourceGroupInfo.getState(), "state is null");
        this.schedulingPolicy = resourceGroupInfo.getSchedulingPolicy();
        this.schedulingWeight = resourceGroupInfo.getSchedulingWeight();
        this.softMemoryLimit = resourceGroupInfo.getSoftMemoryLimit();
        this.softConcurrencyLimit = resourceGroupInfo.getSoftConcurrencyLimit();
        this.hardConcurrencyLimit = resourceGroupInfo.getHardConcurrencyLimit();
        this.maxQueuedQueries = resourceGroupInfo.getMaxQueuedQueries();
        this.memoryUsageBytes = resourceGroupInfo.getMemoryUsage().toBytes();
        this.numQueuedQueries = resourceGroupInfo.getNumQueuedQueries();
        this.numRunningQueries = resourceGroupInfo.getNumRunningQueries();
        this.workersPerQueryLimit = resourceGroupInfo.getWorkersPerQueryLimit();
        this.subGroupsMap = new HashMap<ResourceGroupId, AggregatedResourceGroupInfoBuilder>();
        this.runningQueriesBuilder = ImmutableList.builder();
        this.addRunningQueries(resourceGroupInfo.getRunningQueries());
        this.addSubgroups(resourceGroupInfo.getSubGroups());
    }

    public AggregatedResourceGroupInfoBuilder add(ResourceGroupInfo resourceGroupInfo) {
        if (this.id == null) {
            this.init(resourceGroupInfo);
            return this;
        }
        Preconditions.checkState((resourceGroupInfo != null && this.id.equals((Object)resourceGroupInfo.getId()) ? 1 : 0) != 0);
        this.numQueuedQueries = Math.addExact(this.numQueuedQueries, resourceGroupInfo.getNumQueuedQueries());
        this.numRunningQueries = Math.addExact(this.numRunningQueries, resourceGroupInfo.getNumRunningQueries());
        if (resourceGroupStatePreference.get(resourceGroupInfo.getState()) < resourceGroupStatePreference.get(this.state)) {
            this.state = resourceGroupInfo.getState();
        }
        this.memoryUsageBytes = Math.addExact(this.memoryUsageBytes, resourceGroupInfo.getMemoryUsage().toBytes());
        List<ResourceGroupInfo> subGroups = resourceGroupInfo.getSubGroups();
        this.addSubgroups(subGroups);
        List<QueryStateInfo> runningQueries = resourceGroupInfo.getRunningQueries();
        this.addRunningQueries(runningQueries);
        return this;
    }

    private void addSubgroups(List<ResourceGroupInfo> subGroups) {
        if (subGroups == null) {
            return;
        }
        for (ResourceGroupInfo subgroup : subGroups) {
            this.subGroupsMap.computeIfAbsent(subgroup.getId(), k -> new AggregatedResourceGroupInfoBuilder()).add(subgroup);
        }
    }

    private void addRunningQueries(List<QueryStateInfo> runningQueries) {
        if (runningQueries == null) {
            return;
        }
        this.runningQueriesBuilder.addAll(runningQueries);
    }

    public ResourceGroupInfo build() {
        if (this.id == null) {
            return null;
        }
        ImmutableList runningQueries = this.runningQueriesBuilder.build();
        return new ResourceGroupInfo(this.id, this.state, this.schedulingPolicy, this.schedulingWeight, this.softMemoryLimit, this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.memoryUsageBytes), this.numQueuedQueries, this.numRunningQueries, 0, (List)this.subGroupsMap.values().stream().map(AggregatedResourceGroupInfoBuilder::build).collect(ImmutableList.toImmutableList()), (List<QueryStateInfo>)runningQueries, this.workersPerQueryLimit);
    }
}

