/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.sql;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlType;

@SqlInvokedScalarFunction(value="map_normalize", deterministic=true, calledOnNullInput=false)
@Description(value="Returns the map with the same keys but all non-null values are scaled proportionally so that the sum of values becomes 1.")
public class MapNormalizeFunction {
    private MapNormalizeFunction() {
    }

    @SqlParameter(name="input", type="map<varchar, double>")
    @SqlType(value="map<varchar, double>")
    public static String arraySumDouble() {
        return "RETURN transform(array[ROW(input, cast(array_sum(map_values(input)) as double))], x->transform_values(x[1], (k, v) -> (v / x[2])))[1]";
    }
}

