/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PageProjectionWithOutputs {
    private final PageProjection pageProjection;
    private final int[] outputChannels;

    public PageProjectionWithOutputs(PageProjection pageProjection, int[] outputChannels) {
        this.pageProjection = Objects.requireNonNull(pageProjection, "pageProjection is null");
        this.outputChannels = Arrays.copyOf(Objects.requireNonNull(outputChannels, "outputChannels is null"), outputChannels.length);
    }

    public PageProjection getPageProjection() {
        return this.pageProjection;
    }

    public int getOutputCount() {
        return this.outputChannels.length;
    }

    int[] getOutputChannels() {
        return this.outputChannels;
    }

    Work<List<Block>> project(SqlFunctionProperties sqlFunctionProperties, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return this.pageProjection.project(sqlFunctionProperties, yieldSignal, page, selectedPositions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pageProjection", (Object)this.pageProjection).add("outputChannels", (Object)this.outputChannels).toString();
    }
}

