/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.ReduceAggregationState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.slice.Slice;
import org.openjdk.jol.info.ClassLayout;

public class ReduceAggregationStateFactory
implements AccumulatorStateFactory<ReduceAggregationState> {
    public ReduceAggregationState createSingleState() {
        return new SingleState();
    }

    public Class<? extends ReduceAggregationState> getSingleStateClass() {
        return SingleState.class;
    }

    public ReduceAggregationState createGroupedState() {
        return new GroupedState();
    }

    public Class<? extends ReduceAggregationState> getGroupedStateClass() {
        return GroupedState.class;
    }

    private static long getObjectSizeInBytes(Object value) {
        if (value instanceof Block) {
            return ((Block)value).getRetainedSizeInBytes();
        }
        if (value instanceof Slice) {
            return ((Slice)value).getRetainedSize();
        }
        return 0L;
    }

    public static class SingleState
    implements ReduceAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedState.class).instanceSize();
        private Object value;

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            this.value = value;
        }

        public long getEstimatedSize() {
            return ReduceAggregationStateFactory.getObjectSizeInBytes(this.value) + (long)INSTANCE_SIZE;
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements ReduceAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedState.class).instanceSize();
        private final ObjectBigArray<Object> values = new ObjectBigArray();
        private long size = INSTANCE_SIZE;

        public long getEstimatedSize() {
            return this.size + this.values.sizeOf();
        }

        @Override
        public Object getValue() {
            return this.values.get(this.getGroupId());
        }

        @Override
        public void setValue(Object value) {
            this.size += ReduceAggregationStateFactory.getObjectSizeInBytes(value) - ReduceAggregationStateFactory.getObjectSizeInBytes(this.getValue());
            this.values.set(this.getGroupId(), value);
        }

        public void ensureCapacity(long size) {
            this.values.ensureCapacity(size);
        }
    }
}

