/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class LongDecimalWithOverflowStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowState> {
    private static final int SERIALIZED_SIZE = 24;

    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowState state, BlockBuilder out) {
        Slice decimal = state.getLongDecimal();
        if (decimal == null) {
            out.appendNull();
        } else {
            long overflow = state.getOverflow();
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{overflow, decimal.getLong(0), decimal.getLong(8)}));
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowState state) {
        if (!block.isNull(index)) {
            Slice slice = VarbinaryType.VARBINARY.getSlice(block, index);
            if (slice.length() != 24) {
                throw new IllegalStateException("Unexpected serialized state size: " + slice.length());
            }
            long overflow = slice.getLong(0);
            Slice decimal = Slices.wrappedLongArray((long[])new long[]{slice.getLong(8), slice.getLong(16)});
            state.setOverflow(overflow);
            state.setLongDecimal(decimal);
        }
    }
}

